% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.integrate.r
\name{interpolate_wl}
\alias{interpolate_wl}
\alias{interpolate_wl.default}
\alias{interpolate_wl.generic_spct}
\alias{interpolate_wl.generic_mspct}
\title{Map spectra to new wavelength values.}
\usage{
interpolate_wl(x, w.length.out, fill, length.out, ...)

\method{interpolate_wl}{default}(x, w.length.out, fill, length.out, ...)

\method{interpolate_wl}{generic_spct}(x, w.length.out = NULL, fill = NA, length.out = NULL, ...)

\method{interpolate_wl}{generic_mspct}(
  x,
  w.length.out = NULL,
  fill = NA,
  length.out = NULL,
  ...,
  .parallel = FALSE,
  .paropts = NULL
)
}
\arguments{
\item{x}{an R object}

\item{w.length.out}{numeric vector of wavelengths (nm)}

\item{fill}{a value to be assigned to out of range wavelengths}

\item{length.out}{numeric value}

\item{...}{not used}

\item{.parallel}{if TRUE, apply function in parallel, using parallel backend
provided by foreach}

\item{.paropts}{a list of additional options passed into the foreach function
when parallel computation is enabled. This is important if (for example)
your code relies on external data or packages: use the .export and
.packages arguments to supply them so that all cluster nodes have the
correct environment set up for computing.}
}
\value{
A new spectral object of the same class as argument \code{spct}.
}
\description{
This function returns the result of interpolating spectral data from the original set of
wavelengths to a new one.
}
\details{
If \code{length.out} it is a numeric value, then gives the number of rows in the
output, if it is \code{NULL}, the values in the numeric vector \code{w.length.out} are used.
If both are not \code{NULL} then the range of \code{w.length.out} and \code{length.out} are
used to generate a vector of wavelength. A value of \code{NULL} for \code{fill} prevents
extrapolation.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default for generic function

\item \code{generic_spct}: Interpolate wavelength in an object of class
"generic_spct" or derived.

\item \code{generic_mspct}: Interpolate wavelength in an object of class
"generic_mspct" or derived.
}}

\note{
The default \code{fill = NA} fills extrapolated values with NA. Giving NULL as
argument for \code{fill} deletes wavelengths outside the input data range from the
returned spectrum. A numerical value can be also be provided as fill. This function calls
\code{interpolate_spectrum} for each non-wavelength column in the input spectra object.
}
\examples{
interpolate_wl(sun.spct, 400:500, NA)
interpolate_wl(sun.spct, 400:500, NULL)
interpolate_wl(sun.spct, seq(200, 1000, by=0.1), 0)
interpolate_wl(sun.spct, c(400,500), length.out=201)

}
\concept{interpolate functions}
