% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copy.attr.R
\name{select_spct_attributes}
\alias{select_spct_attributes}
\alias{spct_attributes}
\title{Merge user supplied attribute names with default ones}
\usage{
select_spct_attributes(attributes, attributes.default = spct_attributes())

spct_attributes(.class = "all", attributes = "*")
}
\arguments{
\item{attributes, attributes.default}{character vector or a list of character
vectors.}

\item{.class}{character Name of spectral class.}
}
\value{
A character vector of attribute names.
}
\description{
Allow users to add and subract from default attributes in addition to
providing a given set of attributes.
}
\details{
Vectors of character strings passed as argument to \code{attributes}
  are parsed so that if the first member string is \code{"+"}, the remaining
  members are added to those in \code{attributes.default}; if it is
  \code{"-"} the remaining members are removed from in
  \code{attributes.default}; and if it is \code{"="} the remaining members
  replace those in in \code{attributes.default}. If the first member is none
  of these three strings, the behaviour is the same as when the first string
  is \code{"="}. If \code{attributes} is \code{NULL} all the attributes in
  \code{attributes.default} are used and if it is \code{""} no attribute
  names are returned, \code{""} has precedence over other member values. The
  order of the names of annotations has no meaning: the vector is interpreted
  as a set except for the three possible "operators" at position 1.
}
\seealso{
\code{\link{get_attributes}}

Other measurement metadata functions: 
\code{\link{getFilterProperties}()},
\code{\link{getHowMeasured}()},
\code{\link{getInstrDesc}()},
\code{\link{getInstrSettings}()},
\code{\link{getWhatMeasured}()},
\code{\link{getWhenMeasured}()},
\code{\link{getWhereMeasured}()},
\code{\link{get_attributes}()},
\code{\link{isValidInstrDesc}()},
\code{\link{isValidInstrSettings}()},
\code{\link{setFilterProperties}()},
\code{\link{setHowMeasured}()},
\code{\link{setInstrDesc}()},
\code{\link{setInstrSettings}()},
\code{\link{setWhatMeasured}()},
\code{\link{setWhenMeasured}()},
\code{\link{setWhereMeasured}()},
\code{\link{spct_attr2tb}()},
\code{\link{trimInstrDesc}()},
\code{\link{trimInstrSettings}()}
}
\concept{measurement metadata functions}
