% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.normalize.r
\name{setNormalized}
\alias{setNormalized}
\alias{setNormalised}
\title{Set the "normalized" and "normalization" attributes}
\usage{
setNormalized(
  x,
  norm = FALSE,
  norm.type = NA_character_,
  norm.factors = NA_real_,
  norm.cols = NA_character_
)

setNormalised(
  x,
  norm = FALSE,
  norm.type = NA_character_,
  norm.factors = NA_real_,
  norm.cols = NA_character_
)
}
\arguments{
\item{x}{a generic_spct object.}

\item{norm}{numeric (or logical) Normalization wavelength (nanometres).}

\item{norm.type}{character Type of normalization applied.}

\item{norm.factors}{numeric The scaling factor(s) so that dividing the spectral
values by this factor reverts the normalization.}

\item{norm.cols}{character The name(s) of the data columns normalized.}
}
\description{
Function to write the "normalized" attribute of an existing generic_spct
object.
}
\note{
If \code{x} is not a \code{generic_spct} object, \code{x} is not
  modified. Passing a \code{logical} as argument to \code{norm} is deprecated
  but kept for backwards compatibility.

\code{setNormalised()} is a synonym for this \code{setNormalized()}
  method.
}
\seealso{
Other rescaling functions: 
\code{\link{fscale}()},
\code{\link{fshift}()},
\code{\link{getNormalized}()},
\code{\link{getScaled}()},
\code{\link{is_normalized}()},
\code{\link{is_scaled}()},
\code{\link{normalize}()},
\code{\link{setScaled}()}
}
\concept{rescaling functions}
