% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.classes.r
\name{setKType}
\alias{setKType}
\title{Set the "K.type" attribute}
\usage{
setKType(x, K.type = c("attenuation", "absorption", "scattering"))
}
\arguments{
\item{x}{a solute_spct or a summary_solute_spct object.}

\item{K.type}{character A string, either "attenuation", "absorption" or
"scattering".}
}
\value{
x
}
\description{
Function to set by reference the "K.type" attribute of an existing
solute_spct object
}
\note{
This function alters x itself by reference and in addition
  returns x invisibly. If x is not a solute_spct object, x is not modified
  The behaviour of this function is 'unusual' in that the default for
  parameter \code{K.type} is used only if \code{x} does not already have
  this attribute set.
}
\examples{
print("missing example")

}
\seealso{
Other K attribute functions: 
\code{\link{getKType}()}
}
\concept{K attribute functions}
