% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.data.r
\docType{data}
\name{two_filters.spct}
\alias{two_filters.spct}
\alias{two_filters.mspct}
\alias{polyester.spct}
\alias{yellow_gel.spct}
\title{Transmittance spectrum of plastic films}
\format{
A \code{filter_spct} object with 611 rows and 2 variables.
  Individually as \code{filter_spct} objects, and together as a collection
  stored in a \code{filter_mspct} object and in a long-form
  \code{filter_spct} object.

An object of class \code{filter_mspct} (inherits from \code{generic_mspct}, \code{list}) with 2 rows and 1 columns.

An object of class \code{filter_spct} (inherits from \code{generic_spct}, \code{tbl_df}, \code{tbl}, \code{data.frame}) with 561 rows and 2 columns.

An object of class \code{filter_spct} (inherits from \code{generic_spct}, \code{tbl_df}, \code{tbl}, \code{data.frame}) with 611 rows and 2 columns.
}
\usage{
two_filters.spct

two_filters.mspct

polyester.spct

yellow_gel.spct
}
\description{
Datasets containing the wavelengths at a 1 nm interval and
  fractional total transmittance for a clear polyester film and a yellow
  theatrical "gel".
}
\details{
\itemize{ \item \code{w.length} (nm). \item \code{Tfr}
(0..1). \item \code{spct.idx} (names, only in \code{two_filters.spct}).}
}
\note{
Package 'photobiologyFilters' contains data sets for hundreds of
  optical filters and materials in objects of these same classes, ready to be
  used with package 'photobiology'.
}
\examples{
polyester.spct
yellow_gel.spct
summary(two_filters.mspct)

}
\seealso{
Other Spectral data examples: 
\code{\link{A.illuminant.spct}},
\code{\link{D50.illuminant.spct}},
\code{\link{D65.illuminant.spct}},
\code{\link{Ler_leaf.spct}},
\code{\link{black_body.spct}},
\code{\link{ccd.spct}},
\code{\link{clear.spct}},
\code{\link{filter_cps.mspct}},
\code{\link{green_leaf.spct}},
\code{\link{phenylalanine.spct}},
\code{\link{photodiode.spct}},
\code{\link{sun.spct}},
\code{\link{sun_daily.spct}},
\code{\link{sun_evening.spct}},
\code{\link{two_sensors.mspct}},
\code{\link{water.spct}},
\code{\link{white_led.source_spct}}
}
\concept{Spectral data examples}
\keyword{datasets}
