% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/photons.energy.ratio.r
\name{photons_energy_ratio}
\alias{photons_energy_ratio}
\title{Photon:energy ratio}
\usage{
photons_energy_ratio(w.length, s.irrad, w.band = NULL, unit.in = "energy",
  check.spectrum = TRUE, use.cached.mult = FALSE,
  use.hinges = getOption("photobiology.use.hinges", default = NULL))
}
\arguments{
\item{w.length}{numeric array of wavelength (nm)}

\item{s.irrad}{numeric array of spectral (energy) irradiances (W m-2 nm-1)}

\item{w.band}{waveband}

\item{unit.in}{character Allowed values "energy", and "photon", or its alias
"quantum"}

\item{check.spectrum}{logical Flag telling whether to sanity check input
data, default is TRUE}

\item{use.cached.mult}{logical Flag telling whether multiplier values should
be cached between calls}

\item{use.hinges}{logical Flag telling whether to use hinges to reduce
interpolation errors}
}
\value{
A single numeric value giving the ratio moles-photons per Joule.
}
\description{
This function gives the photons:energy ratio between for one given waveband
of a radiation spectrum.
}
\examples{
# photons:energy ratio
with(sun.data, photons_energy_ratio(w.length, s.e.irrad, new_waveband(400,500)))
# photons:energy ratio for whole spectrum
with(sun.data, photons_energy_ratio(w.length, s.e.irrad))

}
\seealso{
Other photon and energy ratio functions: \code{\link{e_ratio}},
  \code{\link{energy_ratio}}, \code{\link{eq_ratio}},
  \code{\link{photon_ratio}}, \code{\link{q_ratio}},
  \code{\link{qe_ratio}}
}

