% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.classes.r
\name{getWhereMeasured}
\alias{getWhereMeasured}
\alias{getWhereMeasured.default}
\alias{getWhereMeasured.generic_mspct}
\alias{getWhereMeasured.generic_spct}
\alias{getWhereMeasured.summary_generic_spct}
\title{Get the "where.measured" attribute}
\usage{
getWhereMeasured(x, ...)

\method{getWhereMeasured}{default}(x, ...)

\method{getWhereMeasured}{generic_spct}(x, ...)

\method{getWhereMeasured}{summary_generic_spct}(x, ...)

\method{getWhereMeasured}{generic_mspct}(x, ..., idx = !is.null(names(x)))
}
\arguments{
\item{x}{a generic_spct object}

\item{...}{Allows use of additional arguments in methods for other classes.}

\item{idx}{logical whether to add a column with the names of the elements of
spct}
}
\value{
a data.frane with a single row and at least columns "lon" and "lat".
}
\description{
Function to read the "where.measured" attribute of an existing generic_spct.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: default

\item \code{generic_spct}: generic_spct

\item \code{summary_generic_spct}: summary_generic_spct

\item \code{generic_mspct}: generic_mspct
}}
\note{
If x is not a \code{generic_spct} or an object of a derived class
  \code{NA} is returned.
}
\examples{
getWhereMeasured(sun.spct)

}
\seealso{
Other measurement metadata functions: \code{\link{getInstrDesc}},
  \code{\link{getInstrSettings}},
  \code{\link{getWhatMeasured}},
  \code{\link{getWhenMeasured}},
  \code{\link{setInstrDesc}},
  \code{\link{setInstrSettings}},
  \code{\link{setWhatMeasured}},
  \code{\link{setWhenMeasured}},
  \code{\link{setWhereMeasured}}
}

