% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sun.calc.r
\name{sun_angles}
\alias{sun_angles}
\title{Solar angles}
\usage{
sun_angles(time = lubridate::now(), tz = lubridate::tz(time),
  geocode = data.frame(lon = 0, lat = 51.5, address = "Greenwich"),
  use.refraction = FALSE)
}
\arguments{
\item{time}{POSIXct Time, any valid time zone (TZ) is allowed, default is
current time}

\item{tz}{character string indicating time zone to be used in output.}

\item{geocode}{data frame with variables lon and lat as numeric values
(degrees).}

\item{use.refraction}{logical Flag indicating whether to correct for
fraction in the atmosphere}
}
\value{
A data.frame with variables time (in same TZ as input), TZ, solartime,
  longitude, latitude, address, azimuth, and elevation.
}
\description{
This function returns the solar angles for a given time and location.
}
\examples{
library(lubridate)
sun_angles()
sun_angles(ymd_hms("2014-09-23 12:00:00"))
sun_angles(ymd_hms("2014-09-23 12:00:00"),
           geocode = data.frame(lat=60, lon=0))

}
\seealso{
Other astronomy related functions: \code{\link{day_night}},
  \code{\link{format.solar_time}},
  \code{\link{is.solar_time}},
  \code{\link{print.solar_time}}, \code{\link{solar_time}}
}

