#' @title CIE xyz chromaticity coordinates 2 deg data
#'
#' @description A dataset containing wavelengths at a 1 nm interval (390 nm to
#'   830 nm) and the corresponding x, y, and z chromaticity coordinates.
#'   According to proposed CIE 2006 standard. Original data from
#'   \url{http://www.cvrl.org/} downloaded on 2014-04-28 The variables are as
#'   follows:
#'
#' \itemize{
#'   \item w.length (nm)
#'   \item x
#'   \item y
#'   \item z }
#'
#' @author CIE
#'
#' @docType data
#' @keywords datasets
#' @format A chroma_spct object with 441 rows and 4 variables
#' @name ciexyzCC2.spct
#' @family Visual response data examples
NULL

#' @title CIE xyz chromaticity coordinates (CC) 10 deg data
#'
#' @description A dataset containing wavelengths at a 1 nm interval (390 nm to
#'   830 nm) and the corresponding x, y, and z chromaticity coordinates. Derived
#'   from proposed CIE 2006 standard. Original data from
#'   \url{http://www.cvrl.org/} downloaded on 2014-04-29 The variables are as
#'   follows:
#'
#' \itemize{
#'   \item w.length (nm)
#'   \item x
#'   \item y
#'   \item z }
#'
#' @author CIE
#'
#' @docType data
#' @keywords datasets
#' @format A chroma_spct object with 441 rows and 4 variables
#' @name ciexyzCC10.spct
#' @family Visual response data examples
NULL

#' @title Linear energy CIE xyz colour matching function (CMF) 2 deg data
#'
#' @description A dataset containing wavelengths at a 1 nm interval (390 nm to
#'   830 nm) and the corresponding x, y, and z 2 degrees CMF values. Derived
#'   from proposed CIE 2006 standard. Original data from
#'   \url{http://www.cvrl.org/} downloaded on 2014-04-29 The variables are as
#'   follows:
#'
#' \itemize{
#'   \item w.length (nm)
#'   \item x
#'   \item y
#'   \item z }
#'
#' @author CIE
#'
#' @docType data
#' @keywords datasets
#' @format A chroma_spct object with 441 rows and 4 variables
#' @name ciexyzCMF2.spct
#' @family Visual response data examples
NULL

#' @title Linear energy CIE xyz colour matching function (CMF) 10 deg data
#'
#' @description A dataset containing wavelengths at a 1 nm interval (390 nm to
#'   830 nm) and the corresponding x, y, and z 10 degrees CMF values. Derived
#'   from proposed CIE 2006 standard. Original data from
#'   \url{http://www.cvrl.org/} downloaded on 2014-04-29 The variables are as
#'   follows:
#'
#' \itemize{
#'   \item w.length (nm)
#'   \item x
#'   \item y
#'   \item z }
#'
#' @author CIE
#'
#' @docType data
#' @keywords datasets
#' @format A chroma_spct object with 441 rows and 4 variables
#' @name ciexyzCMF10.spct
#' @family Visual response data examples
NULL

#' @title Linear energy CIE 2008 luminous efficiency function 10 deg data
#'
#' @description A dataset containing wavelengths at a 1 nm interval (390 nm to
#'   830 nm) and the corresponding response values for a 10 degrees target.
#'   Original data from \url{http://www.cvrl.org/} downloaded on 2014-04-29 The
#'   variables are as follows:
#'
#' \itemize{
#'   \item w.length (nm)
#'   \item x
#'   \item y
#'   \item z }
#'
#' @author CIE
#'
#' @docType data
#' @keywords datasets
#' @format A chroma_spct object with 441 rows and 4 variables
#' @name ciev10.spct
#' @family Visual response data examples
NULL

#' @title Linear energy CIE 2008 luminous efficiency function 2 deg data
#'
#' @description A dataset containing wavelengths at a 1 nm interval (390 nm to
#'   830 nm) and the corresponding response values for a 2 degrees target.
#'   Original data from \url{http://www.cvrl.org/} downloaded on 2014-04-29 The
#'   variables are as follows:
#'
#' @details
#' \itemize{
#'   \item w.length (nm)
#'   \item x
#'   \item y
#'   \item z }
#'
#' @author CIE
#'
#' @docType data
#' @keywords datasets
#' @format A chroma_spct object with 441 rows and 4 variables
#' @name ciev2.spct
#' @family Visual response data examples
NULL
