% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leaf.data.R
\docType{data}
\name{Ler_leaf.spct}
\alias{Ler_leaf.spct}
\title{Green Arabidopsis leaf reflectance and transmittance.}
\format{An \code{object_spct} object with 2401 rows and 3 variables}
\usage{
Ler_leaf.spct
}
\description{
A dataset of total spectral reflectance and total spectral
  transmittance expressed as fractions of one from the upper surface of a
  leaf of an Arabidopsis thaliana 'Ler' rosette.
}
\details{
\itemize{ \item w.length (nm) \item Rfr (0..1) \item Tfr (0..1)}
}
\note{
Measured with a Jaz spectrometer from Ocean Optics (USA) configured
  with a PX Xenon lamp module and Spectroclip double integrating spheres.
}
\examples{
Ler_leaf.spct

}
\seealso{
Other Spectral data examples: \code{\link{A.illuminant.spct}},
  \code{\link{D65.illuminant.spct}},
  \code{\link{Ler_leaf_rflt.spct}},
  \code{\link{Ler_leaf_trns.spct}},
  \code{\link{Ler_leaf_trns_i.spct}},
  \code{\link{black_body.spct}}, \code{\link{ccd.spct}},
  \code{\link{clear.spct}}, \code{\link{clear_body.spct}},
  \code{\link{filter_cps.mspct}},
  \code{\link{green_leaf.spct}}, \code{\link{opaque.spct}},
  \code{\link{photodiode.spct}},
  \code{\link{polyester.spct}},
  \code{\link{sun.daily.data}},
  \code{\link{sun.daily.spct}}, \code{\link{sun.data}},
  \code{\link{sun.spct}}, \code{\link{white_body.spct}},
  \code{\link{white_led.cps_spct}},
  \code{\link{white_led.raw_spct}},
  \code{\link{white_led.source_spct}},
  \code{\link{yellow_gel.spct}}
}
\author{
Aphalo, P. J. & Wang, F (unpublished data)
}
\keyword{datasets}
