% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.new.r
\name{as.generic_spct}
\alias{as.generic_spct}
\alias{as.calibration_spct}
\alias{as.raw_spct}
\alias{as.cps_spct}
\alias{as.source_spct}
\alias{as.response_spct}
\alias{as.filter_spct}
\alias{as.reflector_spct}
\alias{as.object_spct}
\alias{as.chroma_spct}
\title{Spectral-object copy constructor}
\usage{
as.generic_spct(x, ...)

as.calibration_spct(x, ...)

as.raw_spct(x, ...)

as.cps_spct(x, ...)

as.source_spct(x, time.unit = c("second", "day", "exposure"),
  bswf.used = c("none", "unknown"),
  strict.range = getOption("photobiology.strict.range", default = FALSE), ...)

as.response_spct(x, time.unit = "second", ...)

as.filter_spct(x, Tfr.type = c("total", "internal"),
  strict.range = getOption("photobiology.strict.range", default = FALSE), ...)

as.reflector_spct(x, Rfr.type = c("total", "specular"),
  strict.range = getOption("photobiology.strict.range", default = FALSE), ...)

as.object_spct(x, Tfr.type = c("total", "internal"), Rfr.type = c("total",
  "specular"), strict.range = getOption("photobiology.strict.range", default =
  FALSE), ...)

as.chroma_spct(x, ...)
}
\arguments{
\item{x}{an R object}

\item{...}{other arguments passed to "set" functions}

\item{time.unit}{character A string, "second", "day" or "exposure"}

\item{bswf.used}{character}

\item{strict.range}{logical Flag indicating whether off-range values result
in an error instead of a warning}

\item{Tfr.type}{a character string, either "total" or "internal"}

\item{Rfr.type}{a character string, either "total" or "specular"}
}
\value{
These functions return a copy of \code{x} converted into a given
  class of spectral object, if \code{x} is a valid argument to the
  correcponding set function.
}
\description{
Return a copy of an R object with its class set to a given type of spectrum.
}
\seealso{
Other creation of spectral objects functions: \code{\link{source_spct}}
}
