% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.upgrade.r
\name{upgrade_spectra}
\alias{upgrade_spectra}
\title{Upgrade one or more spectral objects}
\usage{
upgrade_spectra(obj.names = ls(parent.frame()))
}
\arguments{
\item{obj.names}{char Names of objects to upgrade as a vector of character
strings}
}
\value{
The modified object (invisibly).
}
\description{
Update the spectral class names of objects to those used in photobiology (>=
0.6.0).
}
\note{
The objects are modified by reference. The class names with ending
  ".spct" are replaced by their new equivalents ending in "_spct".
  \code{object.names} can safely include names of any R object. Names of
  objects which do not belong to any the old \code{.spct} classes are
  ignored. This makes it possible to supply as argument the output from
  \code{ls}, the default, or its equivalent \code{objects}.
}
\seealso{
Other upgrade from earlier versions: \code{\link{is.old_spct}},
  \code{\link{upgrade_spct}}
}
\concept{upgrade from earlier versions}
