% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mspct.methods.R, R/spct.irrad.r
\name{fluence.source_mspct}
\alias{fluence}
\alias{fluence.default}
\alias{fluence.source_mspct}
\alias{fluence.source_spct}
\title{Fluence}
\usage{
\method{fluence}{source_mspct}(spct, w.band = NULL,
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  exposure.time = NA, wb.trim = getOption("photobiology.waveband.trim",
  default = TRUE), use.cached.mult = getOption("photobiology.use.cached.mult",
  default = FALSE), use.hinges = getOption("photobiology.use.hinges", default
  = NULL), allow.scaled = FALSE, ..., idx = !is.null(names(spct)))

fluence(spct, w.band, unit.out, exposure.time, wb.trim, use.cached.mult,
  use.hinges, allow.scaled, ...)

\method{fluence}{default}(spct, w.band, unit.out, exposure.time, wb.trim,
  use.cached.mult, use.hinges, allow.scaled, ...)

\method{fluence}{source_spct}(spct, w.band = NULL,
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  exposure.time = NA, wb.trim = getOption("photobiology.waveband.trim",
  default = TRUE), use.cached.mult = getOption("photobiology.use.cached.mult",
  default = FALSE), use.hinges = getOption("photobiology.use.hinges", default
  = NULL), allow.scaled = FALSE, ...)
}
\arguments{
\item{spct}{an R object}

\item{w.band}{a list of \code{waveband} objects or a \code{waveband} object}

\item{unit.out}{character string with allowed values "energy", and "photon",
or its alias "quantum"}

\item{exposure.time}{lubridate::duration}

\item{wb.trim}{logical if TRUE wavebands crossing spectral data boundaries
are trimmed, if FALSE, they are discarded}

\item{use.cached.mult}{logical indicating whether multiplier values should be
cached between calls}

\item{use.hinges}{logical indicating whether to use hinges to reduce
interpolation errors}

\item{allow.scaled}{logical indicating whether scaled or normalized spectra
as argument to spct are flagged as an error}

\item{...}{other arguments (possibly ignored)}

\item{idx}{logical whether to add a column with the names of the elements of
spct}
}
\value{
One numeric value for each waveband with no change in scale factor,
  with name attribute set to the name of each waveband unless a named list is
  supplied in which case the names of the list elements are used. The
  time.unit attribute is copied from the spectrum object to the output. Units
  are as follows: If time.unit is second, [W m-2 nm-1] -> [mol s-1 m-2] If
  time.unit is day, [J d-1 m-2 nm-1] -> [mol d-1 m-2]
}
\description{
This function returns the energy or photon fluence for a given waveband of a
light source spectrum and the duration of the exposure.
}
\section{Methods (by class)}{
\itemize{
\item \code{source_mspct}: Calculates fluence from a \code{source_mspct}
object.

\item \code{default}: Default for generic function

\item \code{source_spct}: Calculate photon fluence from a \code{source_spct}
object and the duration of the exposure
}}
\note{
The last two parameters control speed optimizations. The defaults
  should be suitable in mosts cases. If you will use repeatedly the same SWFs
  on many spectra measured at exactly the same wavelengths you may obtain
  some speed up by setting \code{use.cached.mult=TRUE}. However, be aware
  that you are responsible for ensuring that the wavelengths are the same in
  each call, as the only test done is for the length of the \code{w.length}
  vector.
}
\examples{
library(lubridate)
fluence(sun.spct,
        w.band = new_waveband(400,700),
        exposure.time = lubridate::duration(3, "minutes") )

}
\seealso{
Other irradiance functions: \code{\link{e_fluence.source_mspct}},
  \code{\link{e_irrad.source_mspct}},
  \code{\link{energy_irradiance}},
  \code{\link{irrad.source_mspct}},
  \code{\link{irradiance}},
  \code{\link{photon_irradiance}},
  \code{\link{q_fluence.source_mspct}},
  \code{\link{q_irrad.source_mspct}}
}

