% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mspct.methods.R, R/spct.summaries.r, R/waveband.class.r
\name{midpoint.generic_mspct}
\alias{midpoint}
\alias{midpoint.default}
\alias{midpoint.generic_mspct}
\alias{midpoint.generic_spct}
\alias{midpoint.numeric}
\alias{midpoint.waveband}
\title{Central wavelength value}
\usage{
\method{midpoint}{generic_mspct}(x, ..., idx = !is.null(names(x)))

\method{midpoint}{generic_spct}(x, ...)

midpoint(x, ...)

\method{midpoint}{default}(x, ...)

\method{midpoint}{numeric}(x, ...)

\method{midpoint}{waveband}(x, ...)
}
\arguments{
\item{x}{an R object}

\item{...}{not used in current version}

\item{idx}{logical whether to add a column with the names of the elements of spct}
}
\value{
A numeric value equal to (max(x) - min(x)) / 2. In the case of spectral
objects a wavelength in nm. For any other R object, according to available
definitions of \code{\link{min}} and \code{\link{max}}.
}
\description{
A function that returns the wavelength at the center of the wavelength range.
}
\section{Methods (by class)}{
\itemize{
\item \code{generic_mspct}: Method for "generic_mspct" objects.

\item \code{generic_spct}: Method for "generic_spct" objects.

\item \code{default}: Default method for generic function

\item \code{numeric}: Default method for generic function

\item \code{waveband}: Wavelength at center of a "waveband" object.
}}
\examples{
midpoint(sun.spct)

}
\seealso{
Other wavelength summaries: \code{\link{max.generic_mspct}},
  \code{\link{min.generic_mspct}},
  \code{\link{min.waveband}},
  \code{\link{range.generic_mspct}},
  \code{\link{range.waveband}},
  \code{\link{stepsize.generic_mspct}}

Other wavelength summaries: \code{\link{max.generic_mspct}},
  \code{\link{min.generic_mspct}},
  \code{\link{min.waveband}},
  \code{\link{range.generic_mspct}},
  \code{\link{range.waveband}},
  \code{\link{stepsize.generic_mspct}}

Other wavelength summaries: \code{\link{max.generic_mspct}},
  \code{\link{min.generic_mspct}},
  \code{\link{min.waveband}},
  \code{\link{range.generic_mspct}},
  \code{\link{range.waveband}},
  \code{\link{stepsize.generic_mspct}}
}

