% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foreign-conversion.r
\name{mspct2colorSpec}
\alias{mspct2colorSpec}
\alias{spct2colorSpec}
\alias{chroma_spct2colorSpec}
\alias{as.colorSpec}
\alias{as.colorSpec.generic_mspct}
\alias{as.colorSpec.generic_spct}
\alias{as.colorSpec.chroma_spct}
\title{Convert into 'colorSpec::colorSpec' objects}
\usage{
mspct2colorSpec(x, spct.data.var = NULL, multiplier = 1, ...)

spct2colorSpec(x, spct.data.var = NULL, multiplier = 1, ...)

chroma_spct2colorSpec(x, spct.data.var = NULL, multiplier = 1, ...)

\method{as.colorSpec}{generic_mspct}(x, spct.data.var = NULL, multiplier = 1, ...)

\method{as.colorSpec}{generic_spct}(x, spct.data.var = NULL, multiplier = 1, ...)

\method{as.colorSpec}{chroma_spct}(x, spct.data.var = NULL, multiplier = 1, ...)
}
\arguments{
\item{x}{R object}

\item{spct.data.var}{character The name of the variable to read spectral data
from.}

\item{multiplier}{numeric A multiplier to be applied to the 'spc' data to do
unit or scale conversion.}

\item{...}{currently ignored.}
}
\description{
Convert spectral objects (xxxx_spct, xxxx_mspct) as defined in package 
'photobiology' into colorSpec objects preserving as much information as
 possible.
}
\section{Methods (by class)}{
\itemize{
\item \code{as.colorSpec(generic_spct)}: 

\item \code{as.colorSpec(chroma_spct)}: 

}}
\note{
Objects of class \code{colorSpec::colorSpec} do not contain metadata or
  class data from which the units of expression could be obtained. When using
  this function the user needs to use parameter \code{multiplier} to convert 
  the data to what is expected by the object constructors defined in package 
  'photobiology' but should only rarely need to use parameter
  \code{spct.data.var} to select the quantity.
  
  \code{colorSpec::colorSpec} objects may use memory more efficiently than
  spectral objects of the classes for collections of spectra defined in
  package 'photobiology' as wavelengths are assumed to be the same for all
  member spectra, and stored only once while this assumption is not made for
  collections of spectra, allowing different wavelengths and lengths for the
  component spectra. Wavelengths are stored for each spectrum, but as
  spectral classes are derived from 'tbl_df' in many cases no redundant
  copies of wavelength data will be made in memory in spite of the more
  flexible semantics of the objects.
}
\section{Warning!}{
 Always check the sanity of the returned data values, as
  guessing is needed when matching the different classes, and the functions
  defined here are NOT guaranteed to return valid data without help from the
  user through optional function arguments.
}

\examples{

if (requireNamespace("colorSpec", quietly = TRUE)) {
  library(colorSpec)
  as.colorSpec(polyester.spct)
  as.colorSpec(sun.spct)
  as.colorSpec(filter_mspct(list(polyester.spct, yellow_gel.spct)))
}

}
