% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foreign-conversion.r
\name{hyperSpec2mspct}
\alias{hyperSpec2mspct}
\alias{mspct2hyperSpec}
\title{Convert 'hyperSpec::hyperSpec' objects}
\usage{
hyperSpec2mspct(x, member.class, spct.data.var, multiplier = 1, ...)

mspct2hyperSpec(x, spct.data.var, multiplier = 1, ...)
}
\arguments{
\item{x}{hyperSpec object}

\item{member.class}{character One of the spectrum classes defined in package
'photobiology'.}

\item{spct.data.var}{character The name to be used for the 'spc' data when
constructing the spectral objects.}

\item{multiplier}{numeric A multiplier to be applied to the 'spc' data to
do unit or
scale conversion. For example "a.u." units in some examples in package
'hyperSpec' seem to have scale factors applied.}

\item{...}{currently ignored.}
}
\description{
Convert between 'hyperSpec::hyperSpec' objects and collection of spectra
objects (xxxx_mspct) as defined in package 'photobiology' preserving all
information. Collection of spectra objects can be easily converted into
long spectral objects or into tidy data frames.
}
\note{
hyperSpec objects use memory more efficiently than spectral objects
of the classes defined in package 'photobiology' while these are more
flexible as they are derived from 'tbl_df' and in turn from 'data.frame'.
}
\examples{

library(hyperSpec)
data(laser)
wl(laser) <- 
list (wl = 1e7 / (1/405e-7 - wl (laser)),
      label = expression (lambda / nm))
laser.mspct <- hyperSpec2mspct(laser, "source_spct", "s.e.irrad")
class(laser.mspct)

}

