#' Spectral data for LEDs array supplied by Quantum Devices
#' 
#' Datasets containing the wavelengths and tabulated values spectral emittance 
#' for light emitting diodes (LEDs) from Quantum Devices (USA). Data are
#' normalized to one at the wavelength of maximum emission.
#' 
#' The variables are as follows:
#' \itemize{
#'   \item w.length (nm)  
#'   \item s.e.irrad (W m-2 nm-1)
#' }
#' 
#' @docType data
#' @keywords datasets
#' @format A vector of character strings.
#' 
#' @examples 
#' quantum_devices
#' leds.mspct[quantum_devices]
#' 
#' @note 
#' Quantum Devices produces both individual LEDs and luminaires.
#' \url{http://www.quantumdev.com/} 
#' 
"quantum_devices"
