% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lamp-brands.r
\docType{data}
\name{lamp_brands}
\alias{lamp_brands}
\alias{Osram_lamps}
\alias{Philips_lamps}
\alias{Sylvania_lamps}
\alias{QPanel_lamps}
\alias{Airam_lamps}
\alias{Toshiba_lamps}
\alias{Aputure_lamps}
\alias{Sunwayfoto_lamps}
\alias{Godox_lamps}
\alias{Valoya_lamps}
\alias{Fluence_lamps}
\alias{Convoy_lamps}
\alias{Jaxman_lamps}
\alias{Generic_lamps}
\title{Spectral data for Lamps from different suppliers}
\format{
A vector of character strings.

An object of class \code{character} of length 7.

An object of class \code{character} of length 16.

An object of class \code{character} of length 1.

An object of class \code{character} of length 2.

An object of class \code{character} of length 5.

An object of class \code{character} of length 2.

An object of class \code{character} of length 1.

An object of class \code{character} of length 3.

An object of class \code{character} of length 4.

An object of class \code{character} of length 1.

An object of class \code{character} of length 7.

An object of class \code{character} of length 1.

An object of class \code{character} of length 1.

An object of class \code{character} of length 9.
}
\usage{
lamp_brands

Osram_lamps

Philips_lamps

Sylvania_lamps

QPanel_lamps

Airam_lamps

Toshiba_lamps

Aputure_lamps

Sunwayfoto_lamps

Godox_lamps

Valoya_lamps

Fluence_lamps

Convoy_lamps

Jaxman_lamps

Generic_lamps
}
\description{
The collection of spectra \code{\link{lamps.mspct}} contains spectra for 
light bulds, luminaires and other ready-to-use lamps from various current
and former suppliers. The character
vectors described here contain the names of the spectra for lamps from each
brand to facilitate their extraction from the collection. One
additional vector, \code{lamp_brands} contains the names of the brands as used
in the names of the spectra in the collection.
}
\note{
Some of the lamps are from resellers' brands, usually obscure ones, and
  others are from well-known brands. Some of the brands have changed 
  ownership through take-overs and merges. When known the vintage is 
  indicated in the comment field of each spectrum. Multiple brands may also
  belong to the same company.
}
\section{Osram}{

Lamps branded Osram are currently sold by Ledvance, of Chinese ownership.
Osram currently makes and sells other products. When Osram (Germany) and
Sylvania (USA) merged years back both brands remained in use in different
markets and many types of lamps remained differentiated.
 .
}

\section{Philips}{

Lamps branded Philips are sold by Signify Netherlands B.V.
}

\section{Sylvania}{

Lamps branded Sylvania are currently sold by Ledvance in the USA, of Chinese
ownership. Osram currently makes and sells other products. When Osram
(Germany) and Sylvania (USA) merged years back both brands remained in use in
different markets and many types of lamps remained differentiated.
}

\section{Q-LAB}{

Q-Lab Corporation is a global provider of material durability testing 
products including UV-B and UV-A lamps used in test cabinets.
}

\section{Airam}{

Airam Electric Oy Ab is Finnish supplier and manufacturer of lamps and
luminaires.
}

\section{Toshiba}{

Lamps branded Toshiba are sold by Toshiba Lighting.
}

\section{Aputure}{

Aputure is a Chinese supplier of LED lighting and related equipment for filmmaking.
}

\section{Sunwayfoto}{

Sunwayfoto is a Chinese supplier of ancillary equipment for photography,
including battery-powered fill-in LED lights with high CRI ratings..
}

\section{Godox}{

Godox is a Chinese supplier of photography and video lighting equipment. They
sell both LED lights and Xenon flashes of a wide range to output power.
}

\section{Valoya}{

Valoya Oy (Finland) sells LED lamps and luminaires for commercial plant 
cultivation. Both for indoor cultivation and to supplement sunlight in
greenhouses.
}

\section{Fluence}{

Fluence, a division of Osram, sells LED luminaires for commercial plant 
cultivation. Both for indoor cultivation and to supplement sunlight in
greenhouses.
}

\section{Convoy}{

Is a Chinese supplier of LED flashlights/torches and their parts. Sold
through AliExpress, eBay and Banggood.
}

\section{Jaxman}{

Is a Chinese supplier of LED flashlights/torches. Formerly sold
through AliExpress.
}

\section{Generic, shop branded or distributor branded}{

We group under this category shop-branded or generic (no-brand) lamps that
usually have specifications with limited details. These lamps are unlikely to
remain consistent from batch to batch or have limited availability.
}

\examples{
lamp_brands
Osram_lamps

}
\references{
\url{https://www.ledvance.com/}

\url{https://www.lighting.philips.com/}

\url{https://www.ledvanceus.com/Pages/default.aspx}

\url{https://www.q-lab.com/}

\url{https://www.airam.fi/en/}

\url{https://www.tlt.co.jp/tlt/index_e.htm}

\url{https://www.aputure.com/}

\url{http://www.sunwayfoto.com/}

\url{https://www.godox.com/}

\url{https://www.valoya.com/}

\url{https://fluence-led.com/}
}
\seealso{
\code{\link{lamps.mspct}}
}
\keyword{datasets}
