% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Phy-Sigma.r
\name{Phy_Sigma}
\alias{Phy_Sigma}
\title{Phytochrome Sigma as a function of wavelength}
\usage{
Phy_Sigma(w.length)
}
\arguments{
\item{w.length}{numeric array of wavelength (nm)}
}
\value{
a numeric array with values for Sigma
}
\description{
Phytochrome Sigma as a function of wavelength, calculated by interpolatio
from data for Type I Phytochrome as compiled by Mancinelli (1994).
}
\examples{
with(sun.data, Phy_Sigma(w.length))

}
\references{
Mancinelli, A.L. (1994) The physiology of phytochrome action. In
Photomorphogenesis in plants, 2nd edition. R.E. Kendrick and G.H.M.
Kronenberg, eds. Kluwer Academic Publishers, Dordrecht, pp. 211-269. ISBN
978-0-7923-2551-2 (print), 978-94-011-1884-2 (on-line).
\href{http://dx.doi.org/10.1007/978-94-011-1884-2_10}{DOI
10.1007/978-94-011-1884-2_10}
}
\seealso{
\code{\link[photobiologyPlants]{Pfr_Ptot}} and
  \code{\link[photobiologyPlants]{Pfr_Ptot_R_FR}}
}
