% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dna.n.q.fun.r
\name{DNA_N_q_fun}
\alias{DNA_N_q_fun}
\title{Gives values for naked DNA BSWF (SETLOW) as a function of wavelength}
\usage{
DNA_N_q_fun(w.length)
}
\arguments{
\item{w.length}{numeric array of w.length (nm)}
}
\value{
a numeric array of the same length as \code{w.length} with values for
  the BSWF normalized as in the original source.  The returned values are
  based on quantum effectiveness units.
}
\description{
This function gives a set of numeric multipliers that can be used
as a weight to calculate effective doses and irradiances.
}
\note{
The digitized data as used in the TUV model covers the wavelength range
  from 256 nm to 364 nm. For longer wavelengths we set the value to zero, and
  for shorter wavelengths we extrapolate the value for 256 nm.
}
\examples{
DNA_N_q_fun(293:400)
}

