% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_sensitivity.R
\name{compute_sensitivity}
\alias{compute_sensitivity}
\title{Computing measures of sensitivity}
\usage{
compute_sensitivity(
  data,
  varnames = list(Par = "Par", test1 = "test1", test2 = "test2"),
  test1_ref,
  test2_ref
)
}
\arguments{
\item{data}{Dataframe with output from sensitivity_analysis()}

\item{varnames}{Variable names}

\item{test1_ref}{Reference value for parameter}

\item{test2_ref}{Reference value for parameter}
}
\value{
compute_sensitivity calculates two sets of sensitivity measures:
parameter effect (Bauerle et al., 2014), and control coefficient (Capaldo &
Pandis, 1997). This function is useful in determining how much a given
input (assumed or otherwise) can affect the model output and conclusions.
Particularly useful if a given parameter is unknown during a fitting or
modeling process.
}
\description{
Computing measures of sensitivity
}
\examples{
\donttest{
# Read in your data
# Note that this data is coming from data supplied by the package
# hence the complicated argument in read.csv()
# This dataset is a CO2 by light response curve for a single sunflower
data <- read.csv(system.file("extdata", "A_Ci_Q_data_1.csv",
  package = "photosynthesis"
))

# Define a grouping factor based on light intensity to split the ACi
# curves
data$Q_2 <- as.factor((round(data$Qin, digits = 0)))

# Convert leaf temperature to K
data$T_leaf <- data$Tleaf + 273.15

# Run a sensitivity analysis on gamma_star and mesophyll conductance
# at 25 Celsius for one individual curve
# pars <- analyze_sensitivity(
#   data = data[data$Q_2 == 1500, ],
#   funct = fit_aci_response,
#   varnames = list(
#     A_net = "A",
#     T_leaf = "T_leaf",
#     C_i = "Ci",
#     PPFD = "Qin"
#   ),
#   useg_mct = TRUE,
#   test1 = "gamma_star25",
#   element_out = 1,
#   test2 = "g_mc25",
#   fitTPU = TRUE,
#   Ea_gamma_star = 0,
#   Ea_g_mc = 0,
#   values1 = seq(
#     from = 20,
#     to = 60,
#     by = 2
#   ),
#   values2 = seq(
#     from = 0.2,
#     to = 2,
#     by = 0.1
#   )
# )
# Compute measures of sensitivity
# par2 <- compute_sensitivity(
#   data = pars,
#   varnames = list(
#     Par = "V_cmax",
#     test1 = "gamma_star25",
#     test2 = "g_mc25"
#   ),
#   test1_ref = 42,
#   test2_ref = 1
# )
# # Plot control coefficients
# ggplot(par2, aes(y = CE_gamma_star25, x = CE_g_mc25, colour = V_cmax)) +
#   geom_point() +
#   theme_bw()
# # Note that in this case a missing point appears due to an infinity
}
}
\references{
Bauerle WL, Daniels AB, Barnard DM. 2014. Carbon and water flux responses to
physiology by environment interactions: a sensitivity analysis of variation
in climate on photosynthetic and stomatal parameters. Climate Dynamics 42:
2539-2554.

Capaldo KP, Pandis SN 1997. Dimethylsulfide chemistry in the remote marine
atmosphere: evaluation and sensitivity analysis of available mechanisms.
J Geophys Res 102:23251-23267
}
