% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_many.R
\name{fit_many}
\alias{fit_many}
\title{Fitting many functions across groups}
\usage{
fit_many(data, funct, group, progress = TRUE, ...)
}
\arguments{
\item{data}{Dataframe}

\item{funct}{Function to fit}

\item{group}{Grouping variables}

\item{progress}{Flag. Show progress bar?}

\item{...}{Arguments for the function to fit. Use ?functionname
to read the help file on available arguments for a given function.}
}
\value{
fit_many fits a function across every instance of
a grouping variable.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

We are no longer updating this function. Please use generic methods like \code{\link[purrr]{map}} instead. See \code{vignette("light-response")} for an example.
}
\examples{
\donttest{
# Read in your data
# Note that this data is coming from data supplied by the package
# hence the complicated argument in read.csv()
# This dataset is a CO2 by light response curve for a single sunflower
data = read.csv(system.file("extdata", "A_Ci_Q_data_1.csv",
  package = "photosynthesis"
))

# Define a grouping factor based on light intensity to split the ACi
# curves
data$Q_2 = as.factor((round(data$Qin, digits = 0)))

# Convert leaf temperature to K
data$T_leaf = data$Tleaf + 273.15

# Fit many curves
fits = fit_many(
  data = data,
  varnames = list(
    A_net = "A",
    T_leaf = "T_leaf",
    C_i = "Ci",
    PPFD = "Qin"
  ),
  funct = fit_aci_response,
  group = "Q_2"
)

# Print the parameters
# First set of double parentheses selects an individual group value
# Second set selects an element of the sublist
fits[[3]][[1]]

# Print the graph
fits[[3]][[2]]

# Compile graphs into a list for plotting
fits_graphs = compile_data(fits,
  list_element = 2
)


# Compile parameters into dataframe for analysis
fits_pars = compile_data(fits,
  output_type = "dataframe",
  list_element = 1
)
}

}
