% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{data}
\name{ex6}
\alias{ex6}
\title{Example 6--Reaction-Path Calculations}
\source{
\url{http://wwwbrr.cr.usgs.gov/projects/GWC_coupled/phreeqc}
}
\description{
In this example, the precipitation of phases as a result of
incongruent dissolution of K-feldspar (microcline) is investigated. Only the
four phases originally addressed by Helgeson and others (1969)--K-feldspar,
gibbsite, kaolinite, and K-mica (muscovite)--are considered. The
thermodynamic data for the phases (PHASES keyword) are derived from Robie
and others (1978) and are the same as for test problem 5 in the PHREEQE
manual (Parkhurst and others, 1980). The example can be run using the
\code{\link{phrRunString}} routine.
}
\examples{
phrLoadDatabaseString(phreeqc.dat)
phrSetOutputStringsOn(TRUE)
phrRunString(ex6)
phrGetOutputStrings()
}
\references{
\url{http://pubs.usgs.gov/tm/06/a43/pdf/tm6-A43.pdf}
}
\seealso{
Other Examples: \code{\link{ex10}}; \code{\link{ex11}};
  \code{\link{ex12}}; \code{\link{ex13a}},
  \code{\link{ex13b}}, \code{\link{ex13c}};
  \code{\link{ex14}}; \code{\link{ex15}};
  \code{\link{ex16}}; \code{\link{ex17}};
  \code{\link{ex18}}; \code{\link{ex19}};
  \code{\link{ex1}}; \code{\link{ex20a}},
  \code{\link{ex20b}}; \code{\link{ex21}};
  \code{\link{ex22}}; \code{\link{ex2}}; \code{\link{ex3}};
  \code{\link{ex4}}; \code{\link{ex5}}; \code{\link{ex7}};
  \code{\link{ex8}}; \code{\link{ex9}}
}
\keyword{dataset}

