% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/burnin-phybreak.R
\name{burnin.phybreak}
\alias{burnin.phybreak}
\title{MCMC updating of a phybreak-object.}
\usage{
burnin.phybreak(phybreak.object, ncycles, keepphylo = 0.2)
}
\arguments{
\item{phybreak.object}{An object of class \code{phybreak}.}

\item{ncycles}{Number of iterations to be carried out. Each iteration does one update of all parameters and
tree updates with each host as focal host once.}

\item{keepphylo}{The proportion of transmission tree updates keeping the phylotree intact.}
}
\value{
The \code{phybreak}-object provided as input, with variables and parameters changed due to the updating.
}
\description{
This function allows the MCMC chain to burn in. If used after samples have been taken (with \code{\link{sample.phybreak}}), 
  these samples will be returned unchanged in the output.
}
\examples{
#First create a phybreak-object
simulation <- sim.phybreak(obsize = 5)
MCMCstate <- phybreak(data = simulation$sequences, times = simulation$sample.times)

MCMCstate <- burnin.phybreak(MCMCstate, ncycles = 50)
}
\author{
Don Klinkenberg \email{don@xs4all.nl}
}
\references{
\href{http://dx.doi.org/10.1101/069195}{Klinkenberg et al, on biorXiv}.
}

