% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_week.R, R/stat_week_2d.R
\docType{data}
\name{stat_week}
\alias{stat_week}
\alias{StatWeek}
\alias{StatWeek2d}
\title{Calculate week bins from dates}
\usage{
stat_week(
  mapping = NULL,
  data = NULL,
  geom = "bar",
  position = "stack",
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  week_start = getOption("phylepic.week_start"),
  pad = FALSE
)
}
\arguments{
\item{mapping, data, geom, position, na.rm, show.legend, inherit.aes, pad, ...}{See \code{\link[ggplot2:geom_histogram]{ggplot2::stat_bin()}}.}

\item{week_start}{Day the week begins (defaults to Monday).
Can be specified as a case-insensitive English weekday name such as "Monday"
or an integer. Since you generally won't want to mix definitions, it is
more convenient to control this globally with the \code{"phylepic.week_start"}
option, e.g. \code{options(phylepic.week_start = "Monday")}.}
}
\value{
ggplot2 stat layer.
}
\description{
Computes weeks for date data. This is mostly equivalent to
\code{\link[ggplot2:geom_histogram]{ggplot2::stat_bin()}} with the bins fixed to weeks starting on a particular
day.
}
\examples{
library(ggplot2)

set.seed(1)
events <- rep(as.Date("2024-01-31") - 0:30, rpois(31, 2))
df <- data.frame(date = events)

ggplot(df) + stat_week(aes(date), week_start = "Monday")

# or equivalently:
# ggplot(df) + geom_bar(aes(date), stat = "week", week_start = "Monday")
}
\keyword{datasets}
