% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo.phylo.R
\name{rast.sr}
\alias{rast.sr}
\title{Calculate species richness for raster data}
\usage{
rast.sr(x, filename = "", ...)
}
\arguments{
\item{x}{SpatRaster. A SpatRaster containing presence-absence data (0 or 1)
for a set of species.}

\item{filename}{character. Output filename.}

\item{...}{additional arguments to be passed passed down from a calling
function.}
}
\value{
SpatRaster
}
\description{
Calculate the species richness for raster data.
}
\examples{
\donttest{
x <- terra::rast(system.file("extdata", "rast.presab.tif",
package="phyloraster"))
rse <- rast.sr(x)
terra::plot(rse)
}
}
\author{
Gabriela Alves Ferreira and Neander Marcel Heming
}
