% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coerce-index.R
\name{as.data.frame.piar_index}
\alias{as.data.frame.piar_index}
\alias{as.matrix.piar_index}
\title{Coerce an index into a tabular form}
\usage{
\method{as.data.frame}{piar_index}(x, ..., stringsAsFactors = FALSE)

\method{as.matrix}{piar_index}(x, ...)
}
\arguments{
\item{x}{A price index, as made by, e.g., \code{\link[=elemental_index]{elemental_index()}}.}

\item{...}{Not currently used.}

\item{stringsAsFactors}{See \code{\link[=as.data.frame]{as.data.frame()}}.}
}
\value{
\code{as.data.frame()} returns a data frame with three columns: \code{period}, \code{level},
and \code{value}.

\code{as.matrix()} returns a matrix with a row for each level and a column
for each time period.
}
\description{
Turn an index into a data frame or a matrix.
}
\examples{
index <- as_index(matrix(1:6, 2))

as.data.frame(index)
as.matrix(index)

}
\seealso{
\code{\link[=as_index]{as_index()}} to coerce a matrix/data frame of index values into an index
object.

Other index methods: 
\code{\link{[.piar_index}()},
\code{\link{aggregate.piar_index}()},
\code{\link{chain}()},
\code{\link{contrib}()},
\code{\link{head.piar_index}()},
\code{\link{is.na.piar_index}()},
\code{\link{levels.piar_index}()},
\code{\link{mean.piar_index}()},
\code{\link{merge.piar_index}()},
\code{\link{split.piar_index}()},
\code{\link{stack.piar_index}()},
\code{\link{time.piar_index}()},
\code{\link{vcov.aggregate_piar_index}()}
}
\concept{index methods}
