% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.data.frame.pim.environment.R
\docType{methods}
\name{as.data.frame}
\alias{as.data.frame}
\alias{as.data.frame,pim.environment-method}
\title{Convert a pim.environment to a data frame}
\usage{
as.data.frame(x, row.names = NULL, optional = FALSE, ...)

\S4method{as.data.frame}{pim.environment}(x, row.names = NULL,
  optional = FALSE, ...)
}
\arguments{
\item{x}{a \code{pim.environment} object}

\item{row.names}{NULL or a character vector giving the row names for
the data frame. Missing values are not allowed.}

\item{optional}{logical. if TRUE, setting row names and converting
column names (to syntactic names: see \code{\link{make.names}})
is optional}

\item{...}{additional arguments to be passed to or from methods,
including \code{stringsAsFactors}. For more information, see the
function \code{\link[base]{as.data.frame}} from the base package.}
}
\value{
a data frame.
}
\description{
This function extracts all data from a \code{\link{pim.environment}}
and returns it as a data frame. Note that this is the original data
frame, not the one with pseudo observations.
}
\details{
TO DO: Insert link to how to get pseudo observations out.
}
\examples{
# Create a pim environment
data("DysData")
Dys <- new.pim.env(DysData)
str(as.data.frame(Dys))

}

