% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.complete.R
\name{is.complete}
\alias{is.complete}
\title{Check whether a pim environment is complete}
\usage{
is.complete(x)
}
\arguments{
\item{x}{an object of class \code{\link{pim.environment}}}
}
\value{
a single value TRUE or FALSE
}
\description{
Objects of class \code{\link{pim.environment}} can be created with
or without a poset. To check whether an object has a poset included,
you use the function \code{is.complete}
}
\section{Note}{

This function is not written as an S4 method. Might be rewritten
to S4 later on.
}

\examples{
# the constructor returns an empty environment without poset 
is.complete(new.pim.env())

# Constructing a pim environment with a poset
data("FEVData")
FEVenv <- new.pim.env(FEVData, compare="unique")
is.complete(FEVenv)

}
