% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlaceBet.R
\name{PlaceBet}
\alias{PlaceBet}
\title{Place Bet}
\usage{
PlaceBet(stake, sportId, eventId, periodNumber, lineId, betType,
  altLineId = NULL, team = NULL, side = NULL, acceptBetterLine = TRUE,
  winRiskStake = "RISK", oddsFormat = "AMERICAN")
}
\arguments{
\item{stake}{numeric Wager amount in  currency}

\item{sportId}{numeric the sport id}

\item{eventId}{numeric the vent id}

\item{periodNumber}{numeric Number of the period , see Pinnacle API manual}

\item{lineId}{numeric ID of the line}

\item{betType}{BET_TYPE
\itemize{
\item{SPREAD    }
\item{MONEYLINE}
\item{TOTAL_POINTS}
\item{TEAM_TOTAL_POINTS}
}}

\item{altLineId}{numeric ID of the alternate line (lineID must also be included)}

\item{team}{Default = NULL , , see Pinnacle API manual
\itemize{
\item{TEAM1}
\item{TEAM2}
\item{DRAW}
}}

\item{side}{Defaulat = NULL , , see Pinnacle API manual
\itemize{
\item{OVER}
\item{UNDER}
}}

\item{acceptBetterLine}{Default=TRUE ,boolean Whether or not to accept a bet
when there is a line change in favor of the client}

\item{winRiskStake}{Default="RISK", either place the stake to RISK or to WIN
 \itemize{
\item{WIN}
\item{RISK}
}}

\item{oddsFormat}{Default="AMERICAN", Desired Odds Format
\itemize{
\item{AMERICAN}
\item{DECIMAL}
\item{HONGKONG}
\item{INDONESIAN}
\item{MALAY}
}}
}
\value{
list containing :
\itemize{
  \item{status}  If Status is PROCESSED_WITH_ERROR errorCode will be in the response
  \item{errorCode}
}
}
\description{
Place bet in the system
}
\examples{
\donttest{
SetCredentials("TESTAPI","APITEST")
AcceptTermsAndConditions(accepted=TRUE)
PlaceBet (stake=10,
          sportId=1,
          eventId=495418854,
          periodNumber=0,
          lineId=222136736,
          betType="MONEYLINE",
          team="TEAM2",
          acceptBetterLine=TRUE,
          winRiskStake="WIN",
          oddsFormat="AMERICAN")}
}

