% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aliases.R
\name{pipe_collect_out}
\alias{pipe_collect_out}
\title{Collect output from entire pipeline}
\usage{
pipe_collect_out(pip, groupBy = "group", all = FALSE)
}
\arguments{
\item{pip}{\code{Pipeline} object}

\item{groupBy}{\code{string} column of pipeline by which to group the
output.}

\item{all}{\code{logical} if \code{TRUE} all output is collected
regardless of the \code{keepOut} flag. This can be useful for debugging.}
}
\value{
\code{list} containing the output, named after the groups, which,
by default, are the steps.
}
\description{
Collects output afer pipeline run, by default, from all
steps for which \code{keepOut} was set to \code{TRUE} when steps were added
(see \code{\link[=pipe_add]{pipe_add()}}). The output is grouped by the group names (see
\code{group} parameter in \code{\link[=pipe_add]{pipe_add()}}),
which by default are set identical to the step names.
}
\examples{
p <- pipe_new("pipe", data = 1:2)
pipe_add(p, "step1", \(x = ~data) x + 2)
pipe_add(p, "step2", \(x = ~step1) x + 2, keepOut = TRUE)
pipe_run(p)
pipe_collect_out(p)
pipe_collect_out(p, all = TRUE) |> str()

# Grouped output
p <- pipe_new("pipe", data = 1:2)
pipe_add(p, "step1", \(x = ~data) x + 2, group = "add")
pipe_add(p, "step2", \(x = ~step1, y = 2) x + y, group = "add")
pipe_add(p, "step3", \(x = ~data) x * 3, group = "mult")
pipe_add(p, "step4", \(x = ~data, y = 2) x * y, group = "mult")
p

pipe_run(p)
pipe_collect_out(p, all = TRUE) |> str()

# Grouped by state
pipe_set_params(p, list(y = 5))
p

pipe_collect_out(p, groupBy = "state", all = TRUE) |> str()
}
