% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_brts_and_topology.R
\name{combine_brts_and_topology}
\alias{combine_brts_and_topology}
\title{Substitute branching times keeping the topology}
\usage{
combine_brts_and_topology(brts, tree)
}
\arguments{
\item{brts}{numeric vector of (all postive) branching times,
in time units before the present. Assuming no stem, the heighest
value equals the crown age.}

\item{tree}{an ultrametric phylogenetic tree of class \link[ape]{phylo}}
}
\value{
a phylogeny of class \link[ape]{phylo}
}
\description{
Set the branching times (in time units before the present)
of a phylogeny, while preserving its topology.
}
\examples{
# Branching times as 3 (crown age) and 2 (branch of A and B) time units ago
phylogeny <- ape::read.tree(text = "((A:2, B:2):1, C:3);")
# Branching times will be c(3, 2)
as.numeric(ape::branching.times(phylogeny))
# Will be 2
ape::dist.nodes(phylogeny)[1, ape::getMRCA(phylogeny, c("A", "B"))]

# Create a new phylogeny with the same topology, but with
# branching times at 5 (crown age) and 4 (branch of A and B) time units ago
new_phylogeny <- combine_brts_and_topology(
  brts = c(5, 4),
  tree = phylogeny
)
# Will be c(5, 4)
as.numeric(ape::branching.times(new_phylogeny))
# Will be 4
ape::dist.nodes(new_phylogeny)[
    1, ape::getMRCA(new_phylogeny, c("A", "B"))
]
}
\author{
Giovanni Laudanno, David Bapst, Richèl J.C. Bilderbeek
}
