% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sprinkles.R
\name{sprinkles}
\alias{sprinkle}
\alias{sprinkle_print_method}
\alias{sprinkles}
\title{Define Customization to a Table}
\usage{
sprinkle(rows = NULL, cols = NULL, ..., part = c("body", "head", "foot",
  "interfoot", "table"))

sprinkle_print_method(print_method = c("console", "markdown", "html",
  "latex"))
}
\arguments{
\item{rows}{A numeric vector specifying the rows of the table to sprinkle.
See details for more about sprinkling.}

\item{cols}{A numeric (or character) vector specifying the columns (or
column names) to sprinkle.  See details for more about sprinkling.}

\item{...}{named arguments, each of length 1, defining the customizations
  for the given cells.  See "Sprinkles" for a listing of these arguments.}

\item{part}{A character string denoting which part of the table to modify.}

\item{print_method}{A character string giving the print method for the table.}
}
\description{
Customizations to a \code{dust} table are added by "sprinkling"
  with a little extra fairy dust.  Sprinkles are a collection of attributes
  to be applied over a subset of table cells.  They may be added to any
  part of the table, or to the table as a whole.
}
\details{
Sprinkling is done over the intersection of rows and columns.  If
  rows but no columns are specified, sprinkling is performed over all columns
  of the given given rows. The reverse is true for when columns but no rows
  are specified.  If neither columns nor rows are specified, the attribute
  is applied over all of the cells in the table part denoted in \code{part}.

  Whenever \code{part = "table"}, \code{rows} and \code{columns} are ignored
  and the attributes are applied to the entire table.

  If at least one of \code{border}, \code{border_thickness}, \code{border_units},
  \code{border_style} or \code{border_color} is specified, the remaining
  unspecified attributes assume their default values.

  The sprinkles `bg` and `bg_pattern` may not be used together.

  A more detailed demonstration of the use of sprinkles is available in
  \code{vignette("pixiedust", package = "pixiedust")}
}
\section{Sprinkles}{

The following list describes the valid sprinkles that may be defined in the
\code{...} dots argument.  All sprinkles may be defined for any output type, but
only sprinkles recognized by that output type will be applied.  For a complete
list of which sprinkles are recognized by each output type, see
\code{vignette("sprinkles", package = "pixiedust")}.

\itemize{
  \item{\code{bg} }{A character string denoting the color
     for the background.  See "Colors".}
  \item{\code{bg_pattern} }{This is one of the few exceptions to the length 1 rule.
     This accepts a vector of any length.  Background colors are recycled in a
     pattern. See "Colors". If left unspecified but \code{bg_pattern_by} is
     specified, this will default to \code{c("white", "gainsboro")}.}
  \item{\code{bg_pattern_by} }{A character string denoting if the background
     pattern is recycled over rows or columns.  Accepts either \code{"rows"},
     or \code{"columns"} with partial matching and defaults to \code{"rows"}.
     If \code{bg_pattern} is provided, \code{bg_pattern_by} is assumed, meaning
     it is not necessary to explicitly define \code{bg_pattern_by} unless
     changing an existing or default setting.}
  \item{\code{bold} }{Logical value.  If \code{TRUE}, text is rendered in bold.}
  \item{\code{border_collapse} }{Logical.  Defaults to \code{TRUE}.
     This element is only applicable to
     \code{part = "table"} and will be applied to the table regardless
     the value of \code{part} in the call.}
  \item{\code{border} }{This is one of the few exceptions to the length 1 rule.
     Accepts values \code{"left"}, \code{"right"}, \code{"top"},
     \code{"bottom"}, and \code{"all"} with partial matching.  The border will be added
     to the sides indicated.}
  \item{\code{border_thickness} }{A numeric value denoting the thickness
     of the border.  Defaults to \code{1}.}
  \item{\code{border_units} }{A character string taking any one of the
     values \code{"px"} or \code{"pt"} with partial matching.  Defaults
     to \code{"px"}.}
  \item{\code{border_style} }{A character string taking any one of the
     values \code{"solid"}, \code{"dashed"}, \code{"dotted"},
     \code{"double"}, \code{"groove"}, \code{"ridge"}, \code{"inset"},
     \code{"outset"}, \code{"hidden"}, or \code{"none"}.  Defaults
     to \code{"solid"}.}
  \item{\code{border_color} }{A character string denoting the color
     for the border.  See "Colors".}
  \item{\code{fn} }{A function to apply to values in cells.  The function
     should be an expression that acts on the variable \code{value}. For
     example, \code{quote(round(value, 3))}.}
  \item{\code{font_color} }{A character string denoting the color of the
     font.  See "Colors".}
  \item{\code{font_size} }{A numeric value denoting the size of the font.}
  \item{\code{font_size_units} }{A character string giving the units
    of the font size.  Accepts values \code{"px"}, \code{"pt"}, \code{"\%"},
    and \code{"em"}.  Defaults to \code{"px"}.}
  \item{\code{halign} }{A character string denoting the horizontal alignment.
    Accepts any one of the values \code{"left"}, \code{"center"}, or
    \code{"right"}, with partial matching.}
  \item{\code{height} }{A numerical value giving the height of the cells.}
  \item{\code{height_units} }{A character string giving the units for the
    \code{height} argument.  Accepts \code{"px"} and \code{"\%"}. Defaults
    to \code{"px"}.}
  \item{\code{italic} }{Logical value.  If \code{TRUE}, text is rendered in italics.}
  \item{\code{pad} }{A numerical value giving the cell padding in pixels.}
  \item{\code{rotate_degree} }{A numerical value that determines the angle of rotation
     in the clockwise direction.  Use negative values to rotate counter clockwise.}
  \item{\code{round} }{A numerical value for the number of decimal places to
     which numerical values are rounded.  This can also be accomplished through
     the \code{fn} argument, but this argument makes it a bit easier to do.}
  \item{\code{valign} }{A character string giving the vertical alignment for the
     cells.  Accepts the values \code{"top"}, \code{"middle"}, or \code{"bottom"}
     with partial matching.}
  \item{\code{width} }{A numerical value giving the width of the cells.}
  \item{\code{width_units} }{A character string giving the units for the
    \code{width} argument.  Accepts \code{"px"} and \code{"\%"}. Defaults
    to \code{"px"}.}
}
}

\section{Colors}{

Color specifications accept X11 color names (\code{"orchid"}),
hexidecimal names (\code{"#DA70D6"}), rgb names (\code{"rgb(218 112 214)"}),
and rgba (rgb+alpha transparancy; \code{"rgba(218, 112, 214, .75)"}).
Refer to \url{https://en.wikipedia.org/wiki/Web_colors#X11_color_names}.
}
\examples{
x <- dust(lm(mpg ~ qsec + factor(am), data = mtcars))
x + sprinkle(cols = 2:4, round = 3) +
  sprinkle(cols = 5, fn = quote(pvalString(value))) +
  sprinkle(rows = 2, bold = TRUE)
}
\author{
Benjamin Nutter
}
\seealso{
\code{\link{sprinkle_colnames}} for changing column names in a table.
}

