% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-async.R
\name{run_event_loop}
\alias{run_event_loop}
\title{Run event loop to completion}
\usage{
run_event_loop(expr)
}
\arguments{
\item{expr}{Expression to run after creating a new event loop.}
}
\value{
\code{NULL}, always. If the event loop is to return some value,
you can use lexical scoping, see the example below.
}
\description{
Creates a new event loop, evaluates \code{expr} in it, and then runs the
event loop to completion. It stops when the event loop does not have
any tasks.
}
\details{
The expression typically creates event loop tasks. It should not create
deferred values, though, because those will never be evaluated.

Unhandled errors propagate to the \code{run_event_loop()} call, which fails.

In case of an (unhandled) error, all event loop tasks will be cancelled.
}
\examples{
counter <- 0L
do <- function() {
  callback <- function() {
    counter <<- counter + 1L
    if (runif(1) < 1/10) t$cancel()
  }
  t <- async_timer$new(1/1000, callback)
}
run_event_loop(do())
counter
}
