
test_that("version_satisfies", {
  pos <- list(
    list("1.2.3", ">=", "1.2.3"),
    list("1.2.3", ">=", "1.2.0"),
    list("1.2.3", ">=", "1.2"),
    list("1.2.3", ">=", "1.1.9"),

    list("1.2.3", ">",  "1.2.0"),
    list("1.2.3", ">",  "1.2"),
    list("1.2.3", ">",  "1.1.9"),

    list("1.2.2", "<",  "1.2.3"),
    list("1.2",   "<",  "1.2.1"),
    list("1.200", "<",  "2.0"),

    list("1.2.3", "<=", "1.2.3"),
    list("1.2.2", "<=", "1.2.3"),
    list("1.2",   "<=", "1.2.1"),
    list("1.200", "<=", "2.0"),

    list("1.2.3", "==", "1.2.3"),

    list("1.2.3", "!=", "1.2.3.1"),
    list("1.2.3", "!=", "1.2"),
    list("1.2.3", "!=", "1.2.0")
  )
  for (p in pos) expect_true(version_satisfies(p[[1]], p[[2]], p[[3]]))

  neg <- list(
    list("1.2.3", "<",  "1.2.3"),
    list("1.2.3", "<",  "1.2.0"),
    list("1.2.3", "<",  "1.2"),
    list("1.2.3", "<",  "1.1.9"),

    list("1.2.3", "<=", "1.2.0"),
    list("1.2.3", "<=", "1.2"),
    list("1.2.3", "<=", "1.1.9"),

    list("1.2.2", ">=", "1.2.3"),
    list("1.2",   ">=", "1.2.1"),
    list("1.200", ">=", "2.0"),

    list("1.2.3", ">",  "1.2.3"),
    list("1.2.2", ">",  "1.2.3"),
    list("1.2",   ">",  "1.2.1"),
    list("1.200", ">",  "2.0"),

    list("1.2.3", "!=", "1.2.3"),

    list("1.2.3", "==", "1.2.3.1"),
    list("1.2.3", "==", "1.2"),
    list("1.2.3", "==", "1.2.0")
  )
  for (n in neg) expect_false(version_satisfies(n[[1]], n[[2]], n[[3]]))
})
