% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filecache.R
\name{ensure_files_available}
\alias{ensure_files_available}
\title{Ensure all given files exist in the file cache, download them if they are not.}
\usage{
ensure_files_available(pkg_info, relative_filenames, urls,
  files_are_binary = NULL, md5sums = NULL, on_errors = "warn",
  download = TRUE)
}
\arguments{
\item{pkg_info, }{named list. Package identifier, see get_pkg_info() on how to get one.}

\item{relative_filenames, }{vector of strings. A vector of filenames, realtive to the package cache.}

\item{urls, }{vector of strings. For each file, a remote URL where to download the file. Will be passed to `downloader::download`, see that function for URL encoding details.}

\item{files_are_binary, }{logical vector. For each file, whether it is binary. Only required on Windows, when files need to be downloaded. See `downloader::download` docs for details.}

\item{md5sums, }{vector of strings or NULL. A list of MD5 checksums, one for each file in param 'relative_filenames', if not NULL. If given, the files will only be reported as existing if the MD5 sums match.}

\item{on_errors, }{string. What to do if getting the files failed. One of c("warn", "stop", "ignore"). At the end, files are checked using `files_available`(including MD5 if given). Depending on the check results, the behaviours triggered are: "warn": Print a warning for each file that failed the check. "stop": Stop the script, i.e., the whole application. "ignore": Do nothing. You can still react using the return value.}

\item{download, }{logical. Whether to try downloading missing files. Defaults to TRUE. Existing files (with correct MD5 if available) will never be downloaded.}
}
\value{
Named list. The list has entries: "available": vector of strings. The names of the files that are available in the local file cache. You can access them using get_filepath(). "missing": vector of strings. The names of the files that this function was unable to retrieve. "file_status": Logical array indicating whether the files are available. Order is identical to the one in argument 'relative_filenames'.
}
\description{
Ensure all given files exist in the file cache, download them if they are not.
}
\examples{
   pkg_info = get_pkg_info("mypackage");
   local_relative_filenames = c("local_file1.txt", "local_file2.txt");
   bu = "https://raw.githubusercontent.com/dfsp-spirit/";
   url1 = paste(bu, "pkgfilecache/master/inst/extdata/file1.txt", sep="");
   url2 = paste(bu, "pkgfilecache/master/inst/extdata/file2.txt", sep="");
   urls = c(url1, url2);
   md5sums = c("35261471bcd198583c3805ee2a543b1f", "85ffec2e6efb476f1ee1e3e7fddd86de");
   res = ensure_files_available(pkg_info, local_relative_filenames, urls, md5sums=md5sums);
   erase_file_cache(pkg_info); # clear full cache

}
