% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec.R
\name{file_spec}
\alias{file_spec}
\title{Create a file specification}
\usage{
file_spec(
  path,
  pattern = NULL,
  format = c("binary", "text"),
  recursive = TRUE,
  ignore_case = TRUE,
  all_files = FALSE
)
}
\arguments{
\item{path}{Path relative to the package root), for example, \code{"inst/"}.}

\item{pattern}{Regular expression for matching the file names.}

\item{format}{File format type, one of \code{"binary"} or \code{"text"}.}

\item{recursive}{List files in the sub-directories?}

\item{ignore_case}{Should pattern-matching be case-insensitive?}

\item{all_files}{List all files including the invisible ones?}
}
\value{
A file specification object.
}
\description{
Specify which files to include
}
\details{
Most of the parameters are passed through \code{\link[=list.files]{list.files()}}.
}
\section{Specification}{

\if{latex}{
  \itemize{
    \item Define a list of parameters that can be passed to \code{list.files()}.
    \item Store the parameters in a named list.
    \item Assign class \code{file_spec} to the list.
    \item Return the \code{file_spec} object.
  }
}
\if{html}{The contents of this section are shown in PDF user manual only.}
}

\examples{
file_spec(
  "R/",
  pattern = "\\\\.R$", format = "text",
  recursive = FALSE, ignore_case = TRUE, all_files = FALSE
)
}
