% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GraphClasses.R
\name{GraphClasses}
\alias{GraphClasses}
\title{Graph Classes for Network Modeling}
\description{
pkgnet uses R6 classes to define and encapsulate the graph
    models for representing package networks. These classes implement
    different types of graphs and functionality to calculate their respective
    graph theory measures. The base class \code{AbstractGraph} defines the
    standard interfaces and functionality.

    Currently the only implemented type of graph is \link{DirectedGraph}.
}
\section{Class Constructor}{

\describe{
    \item{\code{new(nodes, edges)}}{
        \itemize{
            \item{Instantiate new object of the class.}
            \item{\bold{Args:}}{
                \itemize{
                    \item{\bold{\code{nodes}}: a data.table containing nodes}
                    \item{\bold{\code{edges}}: a data.table containing edges}
                }
            }
            \item{\bold{Returns:}}{
                \itemize{
                    \item{Object of the class}
                }
            }
        }
    }
}
}

\section{Public Methods}{

\describe{
    \item{\code{node_measures(measures = NULL)}}{
        \itemize{
            \item{Return specified node-level measures, calculating if necessary.
            See Node Measures section below for details about each measure.}
            \item{\bold{Args:}}{
                \itemize{
                    \item{\bold{\code{measures}}: character vector of measure
                    names. Default NULL will return those that are already
                    calculated.}
                }
            }
            \item{\bold{Returns:}}{
                \itemize{
                    \item{data.table with specified node meaures as columns}
                }
            }
        }
    }
    \item{\code{graph_measures(measures = NULL)}}{
        \itemize{
            \item{Return specified graph-level measures, calculating if necessary.
            See Graph Measures section below for details about each measure.}
            \item{\bold{Args:}}{
                \itemize{
                    \item{\bold{\code{measures}}: character vector of measure
                    names. Default NULL will return those that are already
                    calculated.}
                }
            }
            \item{\bold{Returns:}}{
                \itemize{
                    \item{list with specified graph measures}
                }
            }
        }
    }
}
}

\section{Public Fields}{

\describe{
    \item{\bold{\code{nodes}}}{: node data.table, read-only}
    \item{\bold{\code{edges}}}{: edge data.table, read-only}
    \item{\bold{\code{igraph}}}{: igraph object, read-only}
    \item{\bold{\code{available_node_measures}}}{: character vector of all
    supported node measures. See Node Measures section below for detailed
    descriptions. Read-only.}
    \item{\bold{\code{available_graph_measures}}}{: character vector of all
    supported graph measures. See Graph Measures section below for detailed
    descriptions. Read-only.}
    \item{\bold{\code{default_node_measures}}}{: character vector of default
    node measures. See Node Measures section below for detailed descriptions.
    Read-only.}
    \item{\bold{\code{default_graph_measures}}}{: character vector of default
    graph measures. See Graph Measures section below for detailed descriptions.
    Read-only.}
}
}

\section{Special Methods}{

\describe{
    \item{\code{clone(deep = FALSE)}}{
        \itemize{
            \item{Method for copying an object. See \href{https://adv-r.hadley.nz/r6.html#r6-semantics}{\emph{Advanced R}} for the intricacies of R6 reference semantics.}
            \item{\bold{Args:}}{
                \itemize{
                    \item{\bold{\code{deep}}: logical. Whether to recursively clone nested R6 objects.}
                }
            }
            \item{\bold{Returns:}}{
                \itemize{
                    \item{Cloned object of this class.}
                }
            }
        }
    }
    \item{\code{print()}}{
        \itemize{
            \item{Print igraph object.}
            \item{\bold{Returns:}}{
                \itemize{
                    \item{Self}
                }
            }
        }
    }
}
}

\keyword{internal}
