% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreatePackageReport.R
\name{PackageReport}
\alias{PackageReport}
\title{Package Report}
\description{
pkgnet compiles one or more package reporters into a package
    report for a specified package. \code{PackageReport} is an R6 class that
    holds all of those reporters and has a method \code{render_report()}
    to generate an HTML report file. You can access each individual reporter
    and modify it using its methods if you wish.

    The function \code{\link{CreatePackageReport}()} is a shortcut for both
    generating a \code{PackageReport} object with instantiated reporters
    and creating the HTML report in one call.
}
\section{Class Constructor}{

\preformatted{DependencyReporter$new(pkg_name, pkg_path = NULL, report_path =
   tempfile(pattern = pkg_name, fileext = ".html"))}
\itemize{
   \item{Initialize an instance of a package report object.}
       \item{\bold{Args:}}{\itemize{
           \item{\bold{\code{pkg_name}} (character string) name of
               package
           }
           \item{\bold{\code{pkg_path}}: (character string) optional
               directory path to source code of the package. It is used
               for calculating test coverage. It can be an absolute or
               relative path.
           }
           \item{\bold{\code{report_path}}: (character string) The
               path and filename of the output report.  Default
               report will be produced in the temporary directory.
           }
       }}
       \item{\bold{Returns:}}{\itemize{
           \item{Instantiated package report object.}
       }}
}
}

\section{Public Methods}{

\describe{
    \item{\code{add_reporter(reporter)}}{
        \itemize{
            \item{Add a reporter to the package report.}
            \item{\bold{Args:}}{
                \item{\bold{\code{reporter}}: Instantiated package reporter
                object
                }
            }
            \item{\bold{Returns:}}{
                \itemize{
                    \item{Self, invisibly.}
                }
            }
        }
    }
    \item{\code{render_report()}}{
        \itemize{
            \item{Render html pkgnet package report.
            }
            \item{\bold{Returns:}}{
                \itemize{
                    \item{Self, invisibly.}
                }
            }
        }
    }
}
}

\section{Public Fields}{

\describe{
    \item{\bold{\code{pkg_name}}}{(character string) name of package.
        Read-only.
    }
    \item{\bold{\code{pkg_path}}}{(character string) path to source code of
        the package. Read-only.
    }
    \item{\bold{\code{report_path}}}{(character string) path and filename
        of output report.
    }
    \item{\bold{\code{SummaryReporter}}}{instantiated pkgnet
        \code{\link{SummaryReporter}} object}
    \item{\bold{\code{DependencyReporter}}}{instantiated pkgnet
        \code{\link{DependencyReporter}} object}
    \item{\bold{\code{FunctionReporter}}}{instantiated pkgnet
        \code{\link{FunctionReporter}} object}
    \item{\bold{\code{InheritanceReporter}}}{instantiated pkgnet
        \code{\link{InheritanceReporter}} object}
}
}

\section{Special Methods}{

\describe{
    \item{\code{clone(deep = FALSE)}}{
        \itemize{
            \item{Method for copying an object. See
                \href{https://adv-r.hadley.nz/r6.html#r6-semantics}{\emph{Advanced R}}
                for the intricacies of R6 reference semantics.
            }
            \item{\bold{Args:}}{
                \itemize{
                    \item{\bold{\code{deep}}(logical) Whether to recursively
                    clone nested R6 objects.
                 }
                }
            }
            \item{\bold{Returns:}}{
                \itemize{
                    \item{Cloned object of this class.}
                }
            }
        }
    }
}
}

\concept{Reporters}
