% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pchit_map.R
\name{pchit_map}
\alias{pchit_map}
\title{Plots a heatmap identifying hits from the first principal component}
\usage{
pchit_map(data, well, plate = 96, threshold = 2, palette = "Spectral")
}
\arguments{
\item{data}{Numerical values, either a dataframe or a matrix}

\item{well}{Vector of well identifers e.g "A01"}

\item{plate}{Number of wells in complete plate (96, 384 or 1536)}

\item{threshold}{Threshold of +/- standard deviations form the average
to determine a hit}

\item{palette}{RColorBrewer palette}
}
\value{
ggplot plot
}
\description{
Converts numerical values  and plate labels intoa plate heatmap
with z-scored principal components coloured dependent on a specified
threshold of standard deviations above or below the average.
}
\examples{
v1 <- rnorm(1:96)
v2 <- rnorm(1:96)
v3 <- rnorm(1:96)
wells <- num_to_well(1:96)
df <- data.frame(wells, v1, v2, v3)


pchit_map(data = df[, 2:4],
          well = df$wells,
          threshold = 1.5)
}
