% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.fitmixture.R
\name{predict.fitmixture}
\alias{predict.fitmixture}
\title{Predictions From a "fitmixture" Object}
\usage{
\method{predict}{fitmixture}(
  object,
  newdata,
  type,
  terms = NULL,
  na.action = na.pass,
  reference = "strata",
  ...
)
}
\arguments{
\item{object}{the result of a call to \code{fit_mixture()}}

\item{newdata}{optional new data to obtain predictions for. The original data is used by default.}

\item{type}{the type of prediction. For the "cox" family, the choices are the linear predictor ("lp"), the risk score exp(lp) ("risk"),
the expected number of events given the covariates and follow-up time ("expected"),
and the terms of the linear predictor ("terms"). The survival probability for a subject is
equal to exp(-expected). For the "gaussian" family, the choices are response ("response") or model term ("terms").
For the other glm families ("poisson", "binomial", "gamma"), the choices are predictions on the scale of the linear predictors ("link"),
response ("response"), or model term ("terms").}

\item{terms}{the terms when type = "terms". By default, all terms are included.}

\item{na.action}{a function for what to do with missing values in \code{newdata}. The default is to predict "NA".}

\item{reference}{when family = "cox", reference for centering predictions. Available options are c("strata" - default,
"sample", "zero"). The default is "strata".}

\item{...}{for future predict arguments}
}
\value{
a vector or matrix of predictions based on arguments specified.
}
\description{
Obtain predictions from a \code{fit_mixture()} object using \code{predict.coxph()}, \code{predict.glm()}, or \code{predict.lm()}.
}
\examples{
## commonness score of first and last names used for linkage
mformula <- ~commf + comml
## hand-linked records are considered "safe" matches
safematches <- ifelse(lifem$hndlnk =="Hand-Linked At Some Level", TRUE, FALSE)
## overall mismatch rate in the data set is assumed to be ~ 0.05
mrate <- 0.05
fit <- fit_mixture(age_at_death ~ poly(unit_yob, 3, raw = TRUE), data = lifem,
                   family = "gaussian", mformula, safematches, mrate)

predict(fit)

}
