% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop_segmented.R
\name{prop_segmented}
\alias{prop_segmented}
\title{Image segmentation with pixels proportion}
\usage{
prop_segmented(
  image,
  nseg = 1,
  index = NULL,
  fill_hull = FALSE,
  filter = FALSE,
  parallel = FALSE,
  workers = NULL,
  show_image = TRUE,
  ncol = NULL,
  nrow = NULL,
  verbose = TRUE
)
}
\arguments{
\item{image}{An object (or a list of objects) of class \code{Image}.}

\item{nseg}{The number of iterative segmentation steps to be performed.}

\item{index}{The index to be used in the image segmentation. See
\code{\link[=image_index]{image_index()}} for more details.}

\item{fill_hull}{Fill holes in the objects? Defaults to \code{FALSE}.}

\item{filter}{Performs median filtering after image processing? defaults to
\code{FALSE}. See more at \code{\link[=image_filter]{image_filter()}}.}

\item{parallel}{Processes the images asynchronously (in parallel) in separate
R sessions running in the background on the same machine. It may speed up
the processing time when \code{image} is a list. The number of sections is set
up to 90\% of available cores.}

\item{workers}{A positive numeric scalar or a function specifying the maximum
number of parallel processes that can be active at the same time.}

\item{show_image}{Show the image results? Defaults to \code{TRUE}.}

\item{nrow, ncol}{Arguments passed on to \code{\link[=image_combine]{image_combine()}}. The number of rows
or columns in the plot grid. Defaults to \code{NULL}, i.e., a square grid is
produced.}

\item{verbose}{If \code{TRUE} (default) a summary is shown in the console.}
}
\value{
A list with the following objects
\itemize{
\item \code{results} A data frame with the number of pixels and proportion of pixels
in relation to the previous segmentation.
\item \code{images} A list of segmented images.
}
}
\description{
Provides (iterative) image segmentation and get the proportion of pixels.
This can be used as an alternative way to compute disease severity without
using color palettes.
}
\examples{
\donttest{
img <- image_import(image_pliman("sev_leaf.jpg"))
image_show(img)

prop_segmented(img,
               nseg = 2,
               index = c("G", "GLI"),
               ncol = 3)
}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
