% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_imagem.R
\name{utils_dpi}
\alias{utils_dpi}
\alias{dpi_to_cm}
\alias{cm_to_dpi}
\alias{pixels_to_cm}
\alias{cm_to_pixels}
\title{Utilities for image resolution}
\usage{
dpi_to_cm(dpi)

cm_to_dpi(cm)

pixels_to_cm(px, dpi)

cm_to_pixels(cm, dpi)
}
\arguments{
\item{dpi}{The image resolution in dots per inch.}

\item{cm}{The size in centimeters.}

\item{px}{The number of pixels.}
}
\value{
A numeric value or a vector of numeric values if the input data is a
vector
}
\description{
Provides useful conversions between size (cm), number of pixels (px) and
resolution (dpi)
}
\examples{
library(pliman)
# Convert  dots per inch to centimeter
dpi_to_cm(c(1, 2, 3))

# Convert centimeters to dots per inch
cm_to_dpi(c(1, 2, 3))

# Convert centimeters to number of pixels with resolution of 96 dpi.
cm_to_pixels(c(1, 2, 3), 96)

# Convert number of pixels to cm with resolution of 96 dpi.
pixels_to_cm(c(1, 2, 3), 96)
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
