% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_measures.R
\name{summary_index}
\alias{summary_index}
\title{Summary an object index}
\usage{
summary_index(object, index, cut_point, select_higher = FALSE)
}
\arguments{
\item{object}{An object computed with \code{\link[=analyze_objects]{analyze_objects()}}.}

\item{index}{The index desired, e.g., \code{"B"}. Note that these value must match
the index(es) used in the argument \code{object_index} of \code{analyze_objects()}.}

\item{cut_point}{The cut point.}

\item{select_higher}{If \code{FALSE} (default) selects the objects with \code{index}
smaller than the \code{cut_point}. Use \code{select_higher = TRUE} to select the
objects with \code{index} higher than \code{cut_point}.}
}
\value{
A list with the following elements:
\itemize{
\item \code{ids} The identification of selected objects.
\item \code{between_id} A data frame with the following columns
\itemize{
\item \code{n} The number of objects.
\item \code{nsel} The number of selected objects.
\item \code{prop} The proportion of objects selected.
\item \code{mean_index_sel}, and \code{mean_index_nsel} The mean value of \code{index} for the
selected and non-selected objects, respectively.
}
\item \code{within_id} A data frame with the following columns
\itemize{
\item \code{id} The object identification
\item \code{n_less} The number of pixels with values lesser than or equal to
\code{cut_point}.
\item \code{n_greater} The number of pixels with values greater than \code{cut_point}.
\item \code{less_ratio} The proportion of pixels with values lesser than or equal to
\code{cut_point}.
\item \code{greater_ratio} The proportion of pixels with values greater than
\code{cut_point}.
}
}
}
\description{
Performs a report of the index between and within objects when \code{object_index}
argument is used in \code{analyze_objects()}. By using a cut point, the number and
proportion of objects with mean value of \code{index} bellow and above \code{cut_point}
are returned. Additionaly, the number and proportion of pixels bellow and
above the cutpoint is shown for each object (id).
}
\examples{
library(pliman)
soy <- image_pliman("soy_green.jpg")
anal <- analyze_objects(soy, object_index = "G")
plot_measures(anal, measure = "G")

summary_index(anal, index = "G", cut_point = 0.5)
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
