% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_mosaic.R
\name{mosaic_analyze_iter}
\alias{mosaic_analyze_iter}
\title{Analyze mosaics iteratively}
\usage{
mosaic_analyze_iter(
  mosaic,
  shapefile,
  basemap = NULL,
  r = 3,
  g = 2,
  b = 1,
  re = NA,
  nir = NA,
  swir = NA,
  tir = NA,
  plot = TRUE,
  verbose = TRUE,
  max_pixels = 3e+06,
  attribute = NULL,
  summarize_fun = "mean",
  segment_plot = FALSE,
  segment_individuals = FALSE,
  segment_index = "VARI",
  plot_index = "VARI",
  color_regions = rev(grDevices::terrain.colors(50)),
  alpha = 0.75,
  quantiles = c(0, 1),
  parallel = FALSE,
  workers = NULL,
  ...
)
}
\arguments{
\item{mosaic}{A mosaic of class \code{SpatRaster}, generally imported with
\code{\link[=mosaic_input]{mosaic_input()}}.}

\item{shapefile}{An optional shapefile containing regions of interest (ROIs)
for analysis.}

\item{basemap}{An optional basemap generated with \code{\link[=mosaic_view]{mosaic_view()}}.}

\item{r, g, b, re, nir, swir, tir}{The red, green, blue, red-edge,  near-infrared,
shortwave Infrared, and thermal infrared bands of the image, respectively.
By default, the function assumes a BGR as input (b = 1, g = 2, r = 3). If a
multispectral image is provided up to seven bands can be used to compute
built-in indexes. There are no limitation of band numbers if the index is
computed using the band name.}

\item{plot}{Logical, indicating whether to generate plots (default: TRUE).}

\item{verbose}{Logical, indicating whether to display verbose output
(default: TRUE).}

\item{max_pixels}{Maximum number of pixels to render in the map or plot
(default: 500000).}

\item{attribute}{The attribute to be shown at the plot when \code{plot} is \code{TRUE}. Defaults to the first \code{summary_fun} and first \code{segment_index}.}

\item{summarize_fun}{The function to compute summaries for the pixel values.
Defaults to "mean," i.e., the mean value of the pixels (either at a plot- or
individual-level) is returned.}

\item{segment_plot}{Logical, indicating whether to segment plots (default:
FALSE). If \code{TRUE}, the \code{segment_index} will be computed, and pixels with
values below the \code{threshold} will be selected.}

\item{segment_individuals}{Logical, indicating whether to segment individuals
within plots (default: FALSE). If \code{TRUE}, the \code{segment_index} will be
computed, and pixels with values below the \code{threshold} will be selected, and
a watershed-based segmentation will be performed.}

\item{segment_index}{The index used for segmentation. The same rule as
\code{plot_index}. Defaults to \code{NULL}}

\item{plot_index}{The index(es) to be computed for the drawn plots. Either a
single vegetation index (e.g., \code{"GLAI"}), a vector of indexes (e.g.,
\code{c("GLAI", "NGRDI", "HUE")}), or a custom index based on the available
bands (e.g., \code{"(R-B)/(R+B)"}). See \code{\link[=pliman_indexes]{pliman_indexes()}} and \code{\link[=image_index]{image_index()}}
for more details.}

\item{color_regions}{The color palette for regions (default:
rev(grDevices::terrain.colors(50))).}

\item{alpha}{opacity of the fill color of the raster layer(s).}

\item{quantiles}{the upper and lower quantiles used for color stretching.}

\item{parallel}{If \code{TRUE} processes the images asynchronously (in parallel) in
separate R sessions running in the background on the same machine. It may
speed up the processing time, especially when \code{pattern} is used is informed.
When \code{object_index} is informed, multiple sections will be used to extract
the RGB values for each object in the image. This may significantly speed up
processing time when an image has lots of objects (say >1000).}

\item{workers}{A positive numeric scalar or a function specifying the number
of parallel processes that can be active at the same time. By default, the
number of sections is set up to 30\% of available cores.}

\item{...}{Further arguments passed on to \code{\link[=mosaic_analyze]{mosaic_analyze()}}}
}
\value{
A list containing the following objects:
\itemize{
\item \code{result_plot}: The results at a plot level.
\item \code{result_plot_summ}: The summary of results at a plot level. When
\code{segment_individuals = TRUE}, the number of individuals, canopy coverage,
and mean values of some shape statistics such as perimeter, length, width,
and diameter are computed.
\item \code{result_individ}: The results at an individual level.
\item \code{map_plot}: An object of class \code{mapview} showing the plot-level results.
\item \code{map_individual}: An object of class \code{mapview} showing the individual-level
results.
}
}
\description{
High-resolution mosaics can take a significant amount of time to analyze,
especially when \code{segment_individuals = TRUE} is used in mosaic_analyze().
This is because the function needs to create in-memory arrays to segment
individual using the watershed algorithm. This process utilizes a for-loop
approach, iteratively analyzing each shape within the mosaic one at a time.
To speed up processing, the function crops the original mosaic to the extent
of the current shape before analyzing it. This reduces the resolution for
that specific analysis, sacrificing some detail for faster processing.
}
