% Generated by roxygen2 (4.0.2): do not edit by hand
\name{calculate_roc}
\alias{calculate_roc}
\title{Calculate the ROC curve}
\usage{
calculate_roc(M, D, ci = FALSE, alpha = 0.05)
}
\arguments{
\item{M}{continuous marker values or predictions of class labels}

\item{D}{class labels}

\item{ci}{Logical, if true, will calculate exact joint confidence regions for
the TPF and FPF}

\item{alpha}{Confidence level, ignored if \code{CI = FALSE}}
}
\value{
Data frame containing cutoffs, and estimated true and false positive
  fractions
}
\description{
Calculate ROC curve given labels and predictions
}
\details{
Confidence intervals for TPF and FPF are calculated using the exact
  method of Clopper and Pearson (1934) each at the level \code{1 - sqrt(1 -
  alpha)}. Based on result 2.4 from Pepe (2003), the cross-product of these
  intervals yields a 1 - alpha % confidence region for (FPF, TPF).
}
\examples{
D.ex <- rbinom(100, 1, .5)
calculate_roc(rnorm(100, mean = D.ex), D.ex)
calculate_roc(rnorm(100, mean = D.ex), D.ex, ci = TRUE)
}

