% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/style_roc.R
\name{style_roc}
\alias{style_roc}
\title{Add guides and annotations to a ROC plot}
\usage{
style_roc(major.breaks = c(0, 0.1, 0.25, 0.5, 0.75, 0.9, 1),
  minor.breaks = c(seq(0, 0.1, by = 0.01), seq(0.9, 1, by = 0.01)),
  guide = TRUE, xlab = "False positive fraction",
  ylab = "True positive fraction", theme = theme_bw)
}
\arguments{
\item{major.breaks}{vector of breakpoints for the major gridlines and axes}

\item{minor.breaks}{vector of breakpoints for the minor gridlines and axes}

\item{guide}{logical, if TRUE draws diagonal guideline}

\item{xlab}{X-axis label}

\item{ylab}{Y-axis label}

\item{theme}{Theme function compatible with ggplot2}
}
\description{
Adds a diagonal guideline, minor grid lines, and optionally direct labels to ggplot objects containing a geom_roc layer.
}
\examples{
D.ex <- rbinom(50, 1, .5)
fakedata <- data.frame(M1 = rnorm(50, mean = D.ex), 
   D = D.ex)
ggplot(fakedata, aes(m = M1, d = D)) + geom_roc() + style_roc()
ggplot(fakedata, aes(m = M1, d = D)) + geom_roc() + style_roc(xlab = "1 - Specificity")
ggplot(fakedata, aes(m = M1, d = D)) + geom_roc() + style_roc(theme = theme_grey)
}
