% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roccurve.R
\name{get_cutoffs_data}
\alias{get_cutoffs_data}
\title{Prepare the cutoff data for the ROC curve}
\usage{
get_cutoffs_data(
  data,
  truth_by,
  score_by,
  cat_by,
  cutoffs_at = NULL,
  cutoffs_labels = NULL,
  cutoffs_accuracy = 0.01,
  n_cuts = 0,
  increasing = TRUE
)
}
\arguments{
\item{data}{A data frame with the truth and score columns.}

\item{truth_by}{A character string of the column name that contains the true class labels.}

\item{score_by}{A character string of the column name that contains the predicted scores.}

\item{cat_by}{A character string of the column name to categorize/group the data.
If specified, the cutoffs will be calculated for each category.}

\item{cutoffs_at}{Vector of user supplied cutoffs to plot as points. If non-NULL,
it will override the values of n_cuts and plot the observed cutoffs closest to the user-supplied ones.}

\item{cutoffs_labels}{vector of user-supplied labels for the cutoffs. Must be a character vector of the
same length as cutoffs_at.}

\item{n_cuts}{An integer to specify the number of cuts on the ROC curve.}

\item{increasing}{TRUE if the score is increasing with the truth (1), FALSE otherwise.}
}
\value{
A data frame with the cutoffs and the corresponding x and y values.
}
\description{
Prepare the cutoff data for the ROC curve
}
\keyword{internal}
