% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxviolinplot.R
\name{BoxViolinPlot}
\alias{BoxViolinPlot}
\title{Box/Violin plot}
\usage{
BoxViolinPlot(
  data,
  x,
  x_sep = "_",
  y = NULL,
  base = c("box", "violin"),
  in_form = c("long", "wide"),
  split_by = NULL,
  split_by_sep = "_",
  symnum_args = NULL,
  sort_x = c("none", "mean_asc", "mean_desc", "mean", "median_asc", "median_desc",
    "median"),
  flip = FALSE,
  keep_empty = FALSE,
  group_by = NULL,
  group_by_sep = "_",
  group_name = NULL,
  x_text_angle = ifelse(isTRUE(flip) && isTRUE(stack), 90, 45),
  step_increase = 0.1,
  fill_mode = ifelse(!is.null(group_by), "dodge", "x"),
  fill_reverse = FALSE,
  theme = "theme_this",
  theme_args = list(),
  palette = "Paired",
  palcolor = NULL,
  alpha = 1,
  aspect.ratio = NULL,
  legend.position = "right",
  legend.direction = "vertical",
  add_point = FALSE,
  pt_color = "grey30",
  pt_size = NULL,
  pt_alpha = 1,
  jitter_width = 0.5,
  jitter_height = 0.1,
  stack = FALSE,
  y_max = NULL,
  y_min = NULL,
  add_box = FALSE,
  box_color = "black",
  box_width = 0.1,
  box_ptsize = 2.5,
  add_trend = FALSE,
  trend_color = NULL,
  trend_linewidth = 1,
  trend_ptsize = 2,
  add_stat = NULL,
  stat_name = NULL,
  stat_color = "black",
  stat_size = 1,
  stat_stroke = 1,
  stat_shape = 25,
  add_bg = FALSE,
  bg_palette = "stripe",
  bg_palcolor = NULL,
  bg_alpha = 0.2,
  add_line = NULL,
  line_color = "red2",
  line_width = 0.6,
  line_type = 2,
  highlight = NULL,
  highlight_color = "red2",
  highlight_size = 1,
  highlight_alpha = 1,
  comparisons = NULL,
  ref_group = NULL,
  pairwise_method = "wilcox.test",
  multiplegroup_comparisons = FALSE,
  multiple_method = "kruskal.test",
  sig_label = "p.format",
  sig_labelsize = 3.5,
  hide_ns = FALSE,
  facet_by = NULL,
  facet_scales = "fixed",
  facet_ncol = NULL,
  facet_nrow = NULL,
  facet_byrow = TRUE,
  title = NULL,
  subtitle = NULL,
  xlab = NULL,
  ylab = NULL,
  seed = 8525,
  combine = TRUE,
  nrow = NULL,
  ncol = NULL,
  byrow = TRUE,
  axes = NULL,
  axis_titles = axes,
  guides = NULL,
  design = NULL,
  ...
)
}
\arguments{
\item{data}{A data frame.}

\item{x}{A character string specifying the column name of the data frame to plot for the x-axis.}

\item{x_sep}{A character string to concatenate the columns in \code{x}, if multiple columns are provided.
When \code{in_form} is "wide", \code{x} columns will not be concatenated.}

\item{y}{A character string specifying the column name of the data frame to plot for the y-axis.}

\item{base}{A character string to specify the base plot type. Either "box" or "violin".}

\item{in_form}{A character string to specify the input data type. Either "long" or "wide".}

\item{split_by}{The column(s) to split data by and plot separately.}

\item{split_by_sep}{The separator for multiple split_by columns. See \code{split_by}}

\item{symnum_args}{A list of arguments to pass to the function \code{symnum} for symbolic number coding of p-values.
For example, \code{symnum_args <- list(cutpoints = c(0, 0.0001, 0.001, 0.01, 0.05, Inf), symbols = c("****", "***", "**", "*", "ns"))}.
In other words, we use the following convention for symbols indicating statistical significance:
\itemize{
\item \code{ns}: p > 0.05
\item \code{*}: p <= 0.05
\item \verb{**}: p <= 0.01
\item \verb{***}: p <= 0.001
\item \verb{****}: p <= 0.0001
}}

\item{sort_x}{A character string to specify the sorting of x-axis. Either "none", "mean_asc", "mean_desc", "mean", "median_asc", "median_desc", "median".}

\item{flip}{A logical value to flip the plot.}

\item{keep_empty}{A logical value indicating whether to keep empty groups.
If FALSE, empty groups will be removed.}

\item{group_by}{Columns to group the data for plotting
For those plotting functions that do not support multiple groups,
They will be concatenated into one column, using \code{group_by_sep} as the separator}

\item{group_by_sep}{The separator for multiple group_by columns. See \code{group_by}}

\item{group_name}{A character string to name the legend of dodge.}

\item{x_text_angle}{A numeric value specifying the angle of the x-axis text.}

\item{step_increase}{A numeric value to specify the step increase in fraction of total height for every
additional comparison of the significance labels.}

\item{fill_mode}{A character string to specify the fill mode. Either "dodge", "x", "mean", "median".}

\item{fill_reverse}{A logical value to reverse the fill colors for gradient fill (mean/median).}

\item{theme}{A character string or a theme class (i.e. ggplot2::theme_classic) specifying the theme to use.
Default is "theme_this".}

\item{theme_args}{A list of arguments to pass to the theme function.}

\item{palette}{A character string specifying the palette to use.
A named list or vector can be used to specify the palettes for different \code{split_by} values.}

\item{palcolor}{A character string specifying the color to use in the palette.
A named list can be used to specify the colors for different \code{split_by} values.
If some values are missing, the values from the palette will be used (palcolor will be NULL for those values).}

\item{alpha}{A numeric value specifying the transparency of the plot.}

\item{aspect.ratio}{A numeric value specifying the aspect ratio of the plot.}

\item{legend.position}{A character string specifying the position of the legend.
if \code{waiver()}, for single groups, the legend will be "none", otherwise "right".}

\item{legend.direction}{A character string specifying the direction of the legend.}

\item{add_point}{A logical value to add (jitter) points to the plot.}

\item{pt_color}{A character string to specify the color of the points.}

\item{pt_size}{A numeric value to specify the size of the points.}

\item{pt_alpha}{A numeric value to specify the transparency of the points.}

\item{jitter_width}{A numeric value to specify the width of the jitter.}

\item{jitter_height}{A numeric value to specify the height of the jitter.}

\item{stack}{A logical value whether to stack the facetted plot by 'facet_by'.}

\item{y_max}{A numeric value or a character string to specify the maximum value of the y-axis.
You can also use quantile notation like "q95" to specify the 95th percentile.
When comparisons are set and a numeric y_max is provided, it will be used to set the y-axis limit, including
the significance labels.}

\item{y_min}{A numeric value or a character string to specify the minimum value of the y-axis.
You can also use quantile notation like "q5" to specify the 5th percentile.}

\item{add_box}{A logical value to add box plot to the plot.}

\item{box_color}{A character string to specify the color of the box plot.}

\item{box_width}{A numeric value to specify the width of the box plot.}

\item{box_ptsize}{A numeric value to specify the size of the box plot points in the middle.}

\item{add_trend}{A logical value to add trend line to the plot.}

\item{trend_color}{A character string to specify the color of the trend line.}

\item{trend_linewidth}{A numeric value to specify the width of the trend line.}

\item{trend_ptsize}{A numeric value to specify the size of the trend line points.}

\item{add_stat}{A character string to add statistical test to the plot.}

\item{stat_name}{A character string to specify the name of the stat legend.}

\item{stat_color}{A character string to specify the color of the statistical test.}

\item{stat_size}{A numeric value to specify the size of the statistical test.}

\item{stat_stroke}{A numeric value to specify the stroke of the statistical test.}

\item{stat_shape}{A numeric value to specify the shape of the statistical test.}

\item{add_bg}{A logical value to add background to the plot.}

\item{bg_palette}{A character string to specify the palette of the background.}

\item{bg_palcolor}{A character vector to specify the colors of the background.}

\item{bg_alpha}{A numeric value to specify the transparency of the background.}

\item{add_line}{A character string to add a line to the plot.}

\item{line_color}{A character string to specify the color of the line.}

\item{line_width}{A numeric value to specify the size of the line.}

\item{line_type}{A numeric value to specify the type of the line.}

\item{highlight}{A vector of character strings to highlight the points.
It should be a subset of the row names of the data.
If TRUE, it will highlight all points.}

\item{highlight_color}{A character string to specify the color of the highlighted points.}

\item{highlight_size}{A numeric value to specify the size of the highlighted points.}

\item{highlight_alpha}{A numeric value to specify the transparency of the highlighted points.}

\item{comparisons}{A logical value or a list of vectors to perform pairwise comparisons.
If \code{TRUE}, it will perform pairwise comparisons for all pairs.}

\item{ref_group}{A character string to specify the reference group for comparisons.}

\item{pairwise_method}{A character string to specify the pairwise comparison method.}

\item{multiplegroup_comparisons}{A logical value to perform multiple group comparisons.}

\item{multiple_method}{A character string to specify the multiple group comparison method.}

\item{sig_label}{A character string to specify the label of the significance test.
For multiple group comparisons (\code{multiplegroup_comparisons = TRUE}), it must be either "p.format" or "p.signif".
For pairwise comparisons, it can be:
\itemize{
\item the column containing the label (e.g.: label = "p" or label = "p.adj"), where p is the p-value.
Other possible values are "p.signif", "p.adj.signif", "p.format", "p.adj.format".
\item an expression that can be formatted by the glue() package.
For example, when specifying \code{label = "Wilcoxon, p = {p}"}, the expression \code{{p}} will be replaced by its value.
\item a combination of plotmath expressions and glue expressions.
You may want some of the statistical parameter in italic; for example: \code{label = "Wilcoxon, p= {p}"}
See https://rpkgs.datanovia.com/ggpubr/reference/geom_pwc.html for more details.
}}

\item{sig_labelsize}{A numeric value to specify the size of the significance test label.}

\item{hide_ns}{A logical value to hide the non-significant comparisons.}

\item{facet_by}{A character string specifying the column name of the data frame to facet the plot.
Otherwise, the data will be split by \code{split_by} and generate multiple plots
and combine them into one using \code{patchwork::wrap_plots}}

\item{facet_scales}{Whether to scale the axes of facets. Default is "fixed"
Other options are "free", "free_x", "free_y". See \code{ggplot2::facet_wrap}}

\item{facet_ncol}{A numeric value specifying the number of columns in the facet.
When facet_by is a single column and facet_wrap is used.}

\item{facet_nrow}{A numeric value specifying the number of rows in the facet.
When facet_by is a single column and facet_wrap is used.}

\item{facet_byrow}{A logical value indicating whether to fill the plots by row. Default is TRUE.}

\item{title}{A character string specifying the title of the plot.
A function can be used to generate the title based on the default title.
This is useful when split_by is used and the title needs to be dynamic.}

\item{subtitle}{A character string specifying the subtitle of the plot.}

\item{xlab}{A character string specifying the x-axis label.}

\item{ylab}{A character string specifying the y-axis label.}

\item{seed}{The random seed to use. Default is 8525.}

\item{combine}{Whether to combine the plots into one when facet is FALSE. Default is TRUE.}

\item{nrow}{A numeric value specifying the number of rows in the facet.}

\item{ncol}{A numeric value specifying the number of columns in the facet.}

\item{byrow}{A logical value indicating whether to fill the plots by row.}

\item{axes}{A string specifying how axes should be treated. Passed to \code{\link[patchwork:wrap_plots]{patchwork::wrap_plots()}}.
Only relevant when \code{split_by} is used and \code{combine} is TRUE.
Options are:
\itemize{
\item 'keep' will retain all axes in individual plots.
\item 'collect' will remove duplicated axes when placed in the same run of rows or columns of the layout.
\item 'collect_x' and 'collect_y' will remove duplicated x-axes in the columns or duplicated y-axes in the rows respectively.
}}

\item{axis_titles}{A string specifying how axis titltes should be treated. Passed to \code{\link[patchwork:wrap_plots]{patchwork::wrap_plots()}}.
Only relevant when \code{split_by} is used and \code{combine} is TRUE.
Options are:
\itemize{
\item 'keep' will retain all axis titles in individual plots.
\item 'collect' will remove duplicated titles in one direction and merge titles in the opposite direction.
\item 'collect_x' and 'collect_y' control this for x-axis titles and y-axis titles respectively.
}}

\item{guides}{A string specifying how guides should be treated in the layout. Passed to \code{\link[patchwork:wrap_plots]{patchwork::wrap_plots()}}.
Only relevant when \code{split_by} is used and \code{combine} is TRUE.
Options are:
\itemize{
\item 'collect' will collect guides below to the given nesting level, removing duplicates.
\item 'keep' will stop collection at this level and let guides be placed alongside their plot.
\item 'auto' will allow guides to be collected if a upper level tries, but place them alongside the plot if not.
}}

\item{design}{Specification of the location of areas in the layout, passed to \code{\link[patchwork:wrap_plots]{patchwork::wrap_plots()}}.
Only relevant when \code{split_by} is used and \code{combine} is TRUE. When specified, \code{nrow}, \code{ncol}, and \code{byrow} are ignored.
See \code{\link[patchwork:wrap_plots]{patchwork::wrap_plots()}} for more details.}

\item{...}{Additional arguments.}
}
\value{
A combined ggplot object or wrap_plots object or a list of ggplot objects
}
\description{
Box/Violin plot
}
\keyword{internal}
