% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pls_func.R
\name{predict.plsr}
\alias{predict.plsr}
\title{Predict from a plsr object}
\usage{
\method{predict}{plsr}(object, new_data, direction = "forward", ...)
}
\arguments{
\item{object}{A plsr object.}

\item{new_data}{The data from which you want to predict.}

\item{direction}{The direction of prediction. Default is "forward" meaning X to Y. Every other argument will result in backward prediction.}

\item{...}{Additional arguments.}
}
\description{
This function can be used to make predictions from one original data space to the other.
Prediction direction can be forward, meaning X to Y direction and backward, meaning Y to X prediction.
}
\examples{
plsr_obj = pls(rating_data,tracking_data,10,10)
prediction=predict(plsr_obj,runif(7,1,101),"forward")
\donttest{
#visualizing results with face tracking data specific function
plsr:::plot_frame(prediction)
}
}
